// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Protected append writes history setting for the blob container with Legal holds. </summary>
    public partial class ProtectedAppendWritesHistory
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ProtectedAppendWritesHistory"/>. </summary>
        internal ProtectedAppendWritesHistory()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ProtectedAppendWritesHistory"/>. </summary>
        /// <param name="allowProtectedAppendWritesAll"> When enabled, new blocks can be written to both 'Append and Bock Blobs' while maintaining legal hold protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. </param>
        /// <param name="timestamp"> Returns the date and time the tag was added. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ProtectedAppendWritesHistory(bool? allowProtectedAppendWritesAll, DateTimeOffset? timestamp, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AllowProtectedAppendWritesAll = allowProtectedAppendWritesAll;
            Timestamp = timestamp;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> When enabled, new blocks can be written to both 'Append and Bock Blobs' while maintaining legal hold protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted. </summary>
        [WirePath("allowProtectedAppendWritesAll")]
        public bool? AllowProtectedAppendWritesAll { get; }
        /// <summary> Returns the date and time the tag was added. </summary>
        [WirePath("timestamp")]
        public DateTimeOffset? Timestamp { get; }
    }
}
