// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> The redundancy type of the account after a planned account failover is performed. </summary>
    public readonly partial struct PostPlannedFailoverRedundancy : IEquatable<PostPlannedFailoverRedundancy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostPlannedFailoverRedundancy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostPlannedFailoverRedundancy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardGrsValue = "Standard_GRS";
        private const string StandardGzrsValue = "Standard_GZRS";
        private const string StandardRagrsValue = "Standard_RAGRS";
        private const string StandardRagzrsValue = "Standard_RAGZRS";

        /// <summary> Standard_GRS. </summary>
        public static PostPlannedFailoverRedundancy StandardGrs { get; } = new PostPlannedFailoverRedundancy(StandardGrsValue);
        /// <summary> Standard_GZRS. </summary>
        public static PostPlannedFailoverRedundancy StandardGzrs { get; } = new PostPlannedFailoverRedundancy(StandardGzrsValue);
        /// <summary> Standard_RAGRS. </summary>
        public static PostPlannedFailoverRedundancy StandardRagrs { get; } = new PostPlannedFailoverRedundancy(StandardRagrsValue);
        /// <summary> Standard_RAGZRS. </summary>
        public static PostPlannedFailoverRedundancy StandardRagzrs { get; } = new PostPlannedFailoverRedundancy(StandardRagzrsValue);
        /// <summary> Determines if two <see cref="PostPlannedFailoverRedundancy"/> values are the same. </summary>
        public static bool operator ==(PostPlannedFailoverRedundancy left, PostPlannedFailoverRedundancy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostPlannedFailoverRedundancy"/> values are not the same. </summary>
        public static bool operator !=(PostPlannedFailoverRedundancy left, PostPlannedFailoverRedundancy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostPlannedFailoverRedundancy"/>. </summary>
        public static implicit operator PostPlannedFailoverRedundancy(string value) => new PostPlannedFailoverRedundancy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostPlannedFailoverRedundancy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostPlannedFailoverRedundancy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
