// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> The redundancy type of the account after an account failover is performed. </summary>
    public readonly partial struct PostFailoverRedundancy : IEquatable<PostFailoverRedundancy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostFailoverRedundancy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostFailoverRedundancy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardLrsValue = "Standard_LRS";
        private const string StandardZrsValue = "Standard_ZRS";

        /// <summary> Standard_LRS. </summary>
        public static PostFailoverRedundancy StandardLrs { get; } = new PostFailoverRedundancy(StandardLrsValue);
        /// <summary> Standard_ZRS. </summary>
        public static PostFailoverRedundancy StandardZrs { get; } = new PostFailoverRedundancy(StandardZrsValue);
        /// <summary> Determines if two <see cref="PostFailoverRedundancy"/> values are the same. </summary>
        public static bool operator ==(PostFailoverRedundancy left, PostFailoverRedundancy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostFailoverRedundancy"/> values are not the same. </summary>
        public static bool operator !=(PostFailoverRedundancy left, PostFailoverRedundancy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostFailoverRedundancy"/>. </summary>
        public static implicit operator PostFailoverRedundancy(string value) => new PostFailoverRedundancy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostFailoverRedundancy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostFailoverRedundancy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
