// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> The replication policy rule between two containers. </summary>
    public partial class ObjectReplicationPolicyRule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ObjectReplicationPolicyRule"/>. </summary>
        /// <param name="sourceContainer"> Required. Source container name. </param>
        /// <param name="destinationContainer"> Required. Destination container name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sourceContainer"/> or <paramref name="destinationContainer"/> is null. </exception>
        public ObjectReplicationPolicyRule(string sourceContainer, string destinationContainer)
        {
            Argument.AssertNotNull(sourceContainer, nameof(sourceContainer));
            Argument.AssertNotNull(destinationContainer, nameof(destinationContainer));

            SourceContainer = sourceContainer;
            DestinationContainer = destinationContainer;
        }

        /// <summary> Initializes a new instance of <see cref="ObjectReplicationPolicyRule"/>. </summary>
        /// <param name="ruleId"> Rule Id is auto-generated for each new rule on destination account. It is required for put policy on source account. </param>
        /// <param name="sourceContainer"> Required. Source container name. </param>
        /// <param name="destinationContainer"> Required. Destination container name. </param>
        /// <param name="filters"> Optional. An object that defines the filter set. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ObjectReplicationPolicyRule(string ruleId, string sourceContainer, string destinationContainer, ObjectReplicationPolicyFilter filters, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RuleId = ruleId;
            SourceContainer = sourceContainer;
            DestinationContainer = destinationContainer;
            Filters = filters;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ObjectReplicationPolicyRule"/> for deserialization. </summary>
        internal ObjectReplicationPolicyRule()
        {
        }

        /// <summary> Rule Id is auto-generated for each new rule on destination account. It is required for put policy on source account. </summary>
        [WirePath("ruleId")]
        public string RuleId { get; set; }
        /// <summary> Required. Source container name. </summary>
        [WirePath("sourceContainer")]
        public string SourceContainer { get; set; }
        /// <summary> Required. Destination container name. </summary>
        [WirePath("destinationContainer")]
        public string DestinationContainer { get; set; }
        /// <summary> Optional. An object that defines the filter set. </summary>
        [WirePath("filters")]
        public ObjectReplicationPolicyFilter Filters { get; set; }
    }
}
