// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Type of issue. </summary>
    public readonly partial struct NetworkSecurityPerimeterProvisioningIssueType : IEquatable<NetworkSecurityPerimeterProvisioningIssueType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityPerimeterProvisioningIssueType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkSecurityPerimeterProvisioningIssueType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string ConfigurationPropagationFailureValue = "ConfigurationPropagationFailure";

        /// <summary> Unknown. </summary>
        public static NetworkSecurityPerimeterProvisioningIssueType Unknown { get; } = new NetworkSecurityPerimeterProvisioningIssueType(UnknownValue);
        /// <summary> ConfigurationPropagationFailure. </summary>
        public static NetworkSecurityPerimeterProvisioningIssueType ConfigurationPropagationFailure { get; } = new NetworkSecurityPerimeterProvisioningIssueType(ConfigurationPropagationFailureValue);
        /// <summary> Determines if two <see cref="NetworkSecurityPerimeterProvisioningIssueType"/> values are the same. </summary>
        public static bool operator ==(NetworkSecurityPerimeterProvisioningIssueType left, NetworkSecurityPerimeterProvisioningIssueType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkSecurityPerimeterProvisioningIssueType"/> values are not the same. </summary>
        public static bool operator !=(NetworkSecurityPerimeterProvisioningIssueType left, NetworkSecurityPerimeterProvisioningIssueType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkSecurityPerimeterProvisioningIssueType"/>. </summary>
        public static implicit operator NetworkSecurityPerimeterProvisioningIssueType(string value) => new NetworkSecurityPerimeterProvisioningIssueType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkSecurityPerimeterProvisioningIssueType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkSecurityPerimeterProvisioningIssueType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
