// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Severity of the issue. </summary>
    public readonly partial struct NetworkSecurityPerimeterProvisioningIssueSeverity : IEquatable<NetworkSecurityPerimeterProvisioningIssueSeverity>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityPerimeterProvisioningIssueSeverity"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NetworkSecurityPerimeterProvisioningIssueSeverity(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string WarningValue = "Warning";
        private const string ErrorValue = "Error";

        /// <summary> Warning. </summary>
        public static NetworkSecurityPerimeterProvisioningIssueSeverity Warning { get; } = new NetworkSecurityPerimeterProvisioningIssueSeverity(WarningValue);
        /// <summary> Error. </summary>
        public static NetworkSecurityPerimeterProvisioningIssueSeverity Error { get; } = new NetworkSecurityPerimeterProvisioningIssueSeverity(ErrorValue);
        /// <summary> Determines if two <see cref="NetworkSecurityPerimeterProvisioningIssueSeverity"/> values are the same. </summary>
        public static bool operator ==(NetworkSecurityPerimeterProvisioningIssueSeverity left, NetworkSecurityPerimeterProvisioningIssueSeverity right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NetworkSecurityPerimeterProvisioningIssueSeverity"/> values are not the same. </summary>
        public static bool operator !=(NetworkSecurityPerimeterProvisioningIssueSeverity left, NetworkSecurityPerimeterProvisioningIssueSeverity right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NetworkSecurityPerimeterProvisioningIssueSeverity"/>. </summary>
        public static implicit operator NetworkSecurityPerimeterProvisioningIssueSeverity(string value) => new NetworkSecurityPerimeterProvisioningIssueSeverity(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NetworkSecurityPerimeterProvisioningIssueSeverity other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NetworkSecurityPerimeterProvisioningIssueSeverity other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
