// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Network Security Perimeter profile. </summary>
    public partial class NetworkSecurityPerimeterConfigurationPropertiesProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityPerimeterConfigurationPropertiesProfile"/>. </summary>
        internal NetworkSecurityPerimeterConfigurationPropertiesProfile()
        {
            AccessRules = new ChangeTrackingList<NspAccessRule>();
            EnabledLogCategories = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="NetworkSecurityPerimeterConfigurationPropertiesProfile"/>. </summary>
        /// <param name="name"> Name of the resource. </param>
        /// <param name="accessRulesVersion"> Current access rules version. </param>
        /// <param name="accessRules"> List of Access Rules. </param>
        /// <param name="diagnosticSettingsVersion"> Diagnostic settings version. </param>
        /// <param name="enabledLogCategories"> Enabled logging categories. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NetworkSecurityPerimeterConfigurationPropertiesProfile(string name, float? accessRulesVersion, IReadOnlyList<NspAccessRule> accessRules, float? diagnosticSettingsVersion, IReadOnlyList<string> enabledLogCategories, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            AccessRulesVersion = accessRulesVersion;
            AccessRules = accessRules;
            DiagnosticSettingsVersion = diagnosticSettingsVersion;
            EnabledLogCategories = enabledLogCategories;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the resource. </summary>
        [WirePath("name")]
        public string Name { get; }
        /// <summary> Current access rules version. </summary>
        [WirePath("accessRulesVersion")]
        public float? AccessRulesVersion { get; }
        /// <summary> List of Access Rules. </summary>
        [WirePath("accessRules")]
        public IReadOnlyList<NspAccessRule> AccessRules { get; }
        /// <summary> Diagnostic settings version. </summary>
        [WirePath("diagnosticSettingsVersion")]
        public float? DiagnosticSettingsVersion { get; }
        /// <summary> Enabled logging categories. </summary>
        [WirePath("enabledLogCategories")]
        public IReadOnlyList<string> EnabledLogCategories { get; }
    }
}
