// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Management policy action for snapshot. </summary>
    public partial class ManagementPolicySnapShot
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ManagementPolicySnapShot"/>. </summary>
        public ManagementPolicySnapShot()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ManagementPolicySnapShot"/>. </summary>
        /// <param name="tierToCool"> The function to tier blob snapshot to cool storage. </param>
        /// <param name="tierToArchive"> The function to tier blob snapshot to archive storage. </param>
        /// <param name="tierToCold"> The function to tier blobs to cold storage. </param>
        /// <param name="tierToHot"> The function to tier blobs to hot storage. This action can only be used with Premium Block Blob Storage Accounts. </param>
        /// <param name="delete"> The function to delete the blob snapshot. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ManagementPolicySnapShot(DateAfterCreation tierToCool, DateAfterCreation tierToArchive, DateAfterCreation tierToCold, DateAfterCreation tierToHot, DateAfterCreation delete, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TierToCool = tierToCool;
            TierToArchive = tierToArchive;
            TierToCold = tierToCold;
            TierToHot = tierToHot;
            Delete = delete;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The function to tier blob snapshot to cool storage. </summary>
        [WirePath("tierToCool")]
        public DateAfterCreation TierToCool { get; set; }
        /// <summary> The function to tier blob snapshot to archive storage. </summary>
        [WirePath("tierToArchive")]
        public DateAfterCreation TierToArchive { get; set; }
        /// <summary> The function to tier blobs to cold storage. </summary>
        [WirePath("tierToCold")]
        public DateAfterCreation TierToCold { get; set; }
        /// <summary> The function to tier blobs to hot storage. This action can only be used with Premium Block Blob Storage Accounts. </summary>
        [WirePath("tierToHot")]
        public DateAfterCreation TierToHot { get; set; }
        /// <summary> The function to delete the blob snapshot. </summary>
        [WirePath("delete")]
        public DateAfterCreation Delete { get; set; }
    }
}
