// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> The valid value is Lifecycle. </summary>
    public readonly partial struct ManagementPolicyRuleType : IEquatable<ManagementPolicyRuleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagementPolicyRuleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagementPolicyRuleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LifecycleValue = "Lifecycle";

        /// <summary> Lifecycle. </summary>
        public static ManagementPolicyRuleType Lifecycle { get; } = new ManagementPolicyRuleType(LifecycleValue);
        /// <summary> Determines if two <see cref="ManagementPolicyRuleType"/> values are the same. </summary>
        public static bool operator ==(ManagementPolicyRuleType left, ManagementPolicyRuleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagementPolicyRuleType"/> values are not the same. </summary>
        public static bool operator !=(ManagementPolicyRuleType left, ManagementPolicyRuleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagementPolicyRuleType"/>. </summary>
        public static implicit operator ManagementPolicyRuleType(string value) => new ManagementPolicyRuleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagementPolicyRuleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagementPolicyRuleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
