// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Filters limit rule actions to a subset of blobs within the storage account. If multiple filters are defined, a logical AND is performed on all filters. </summary>
    public partial class ManagementPolicyFilter
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ManagementPolicyFilter"/>. </summary>
        /// <param name="blobTypes"> An array of predefined enum values. Currently blockBlob supports all tiering and delete actions. Only delete actions are supported for appendBlob. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="blobTypes"/> is null. </exception>
        public ManagementPolicyFilter(IEnumerable<string> blobTypes)
        {
            Argument.AssertNotNull(blobTypes, nameof(blobTypes));

            PrefixMatch = new ChangeTrackingList<string>();
            BlobTypes = blobTypes.ToList();
            BlobIndexMatch = new ChangeTrackingList<ManagementPolicyTagFilter>();
        }

        /// <summary> Initializes a new instance of <see cref="ManagementPolicyFilter"/>. </summary>
        /// <param name="prefixMatch"> An array of strings for prefixes to be match. </param>
        /// <param name="blobTypes"> An array of predefined enum values. Currently blockBlob supports all tiering and delete actions. Only delete actions are supported for appendBlob. </param>
        /// <param name="blobIndexMatch"> An array of blob index tag based filters, there can be at most 10 tag filters. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ManagementPolicyFilter(IList<string> prefixMatch, IList<string> blobTypes, IList<ManagementPolicyTagFilter> blobIndexMatch, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PrefixMatch = prefixMatch;
            BlobTypes = blobTypes;
            BlobIndexMatch = blobIndexMatch;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ManagementPolicyFilter"/> for deserialization. </summary>
        internal ManagementPolicyFilter()
        {
        }

        /// <summary> An array of strings for prefixes to be match. </summary>
        [WirePath("prefixMatch")]
        public IList<string> PrefixMatch { get; }
        /// <summary> An array of predefined enum values. Currently blockBlob supports all tiering and delete actions. Only delete actions are supported for appendBlob. </summary>
        [WirePath("blobTypes")]
        public IList<string> BlobTypes { get; }
        /// <summary> An array of blob index tag based filters, there can be at most 10 tag filters. </summary>
        [WirePath("blobIndexMatch")]
        public IList<ManagementPolicyTagFilter> BlobIndexMatch { get; }
    }
}
