// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> A tag of the LegalHold of a blob container. </summary>
    public partial class LegalHoldTag
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LegalHoldTag"/>. </summary>
        internal LegalHoldTag()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LegalHoldTag"/>. </summary>
        /// <param name="tag"> The tag value. </param>
        /// <param name="timestamp"> Returns the date and time the tag was added. </param>
        /// <param name="objectIdentifier"> Returns the Object ID of the user who added the tag. </param>
        /// <param name="tenantId"> Returns the Tenant ID that issued the token for the user who added the tag. </param>
        /// <param name="upn"> Returns the User Principal Name of the user who added the tag. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LegalHoldTag(string tag, DateTimeOffset? timestamp, string objectIdentifier, Guid? tenantId, string upn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Tag = tag;
            Timestamp = timestamp;
            ObjectIdentifier = objectIdentifier;
            TenantId = tenantId;
            Upn = upn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The tag value. </summary>
        [WirePath("tag")]
        public string Tag { get; }
        /// <summary> Returns the date and time the tag was added. </summary>
        [WirePath("timestamp")]
        public DateTimeOffset? Timestamp { get; }
        /// <summary> Returns the Object ID of the user who added the tag. </summary>
        [WirePath("objectIdentifier")]
        public string ObjectIdentifier { get; }
        /// <summary> Returns the Tenant ID that issued the token for the user who added the tag. </summary>
        [WirePath("tenantId")]
        public Guid? TenantId { get; }
        /// <summary> Returns the User Principal Name of the user who added the tag. </summary>
        [WirePath("upn")]
        public string Upn { get; }
    }
}
