// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Statistics related to replication for storage account's Blob, Table, Queue and File services. It is only available when geo-redundant replication is enabled for the storage account. </summary>
    public partial class GeoReplicationStatistics
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GeoReplicationStatistics"/>. </summary>
        internal GeoReplicationStatistics()
        {
        }

        /// <summary> Initializes a new instance of <see cref="GeoReplicationStatistics"/>. </summary>
        /// <param name="status"> The status of the secondary location. Possible values are: - Live: Indicates that the secondary location is active and operational. - Bootstrap: Indicates initial synchronization from the primary location to the secondary location is in progress.This typically occurs when replication is first enabled. - Unavailable: Indicates that the secondary location is temporarily unavailable. </param>
        /// <param name="lastSyncOn"> All primary writes preceding this UTC date/time value are guaranteed to be available for read operations. Primary writes following this point in time may or may not be available for reads. Element may be default value if value of LastSyncTime is not available, this can happen if secondary is offline or we are in bootstrap. </param>
        /// <param name="canFailover"> A boolean flag which indicates whether or not account failover is supported for the account. </param>
        /// <param name="canPlannedFailover"> A boolean flag which indicates whether or not planned account failover is supported for the account. </param>
        /// <param name="postFailoverRedundancy"> The redundancy type of the account after an account failover is performed. </param>
        /// <param name="postPlannedFailoverRedundancy"> The redundancy type of the account after a planned account failover is performed. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GeoReplicationStatistics(GeoReplicationStatus? status, DateTimeOffset? lastSyncOn, bool? canFailover, bool? canPlannedFailover, PostFailoverRedundancy? postFailoverRedundancy, PostPlannedFailoverRedundancy? postPlannedFailoverRedundancy, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            LastSyncOn = lastSyncOn;
            CanFailover = canFailover;
            CanPlannedFailover = canPlannedFailover;
            PostFailoverRedundancy = postFailoverRedundancy;
            PostPlannedFailoverRedundancy = postPlannedFailoverRedundancy;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The status of the secondary location. Possible values are: - Live: Indicates that the secondary location is active and operational. - Bootstrap: Indicates initial synchronization from the primary location to the secondary location is in progress.This typically occurs when replication is first enabled. - Unavailable: Indicates that the secondary location is temporarily unavailable. </summary>
        [WirePath("status")]
        public GeoReplicationStatus? Status { get; }
        /// <summary> All primary writes preceding this UTC date/time value are guaranteed to be available for read operations. Primary writes following this point in time may or may not be available for reads. Element may be default value if value of LastSyncTime is not available, this can happen if secondary is offline or we are in bootstrap. </summary>
        [WirePath("lastSyncTime")]
        public DateTimeOffset? LastSyncOn { get; }
        /// <summary> A boolean flag which indicates whether or not account failover is supported for the account. </summary>
        [WirePath("canFailover")]
        public bool? CanFailover { get; }
        /// <summary> A boolean flag which indicates whether or not planned account failover is supported for the account. </summary>
        [WirePath("canPlannedFailover")]
        public bool? CanPlannedFailover { get; }
        /// <summary> The redundancy type of the account after an account failover is performed. </summary>
        [WirePath("postFailoverRedundancy")]
        public PostFailoverRedundancy? PostFailoverRedundancy { get; }
        /// <summary> The redundancy type of the account after a planned account failover is performed. </summary>
        [WirePath("postPlannedFailoverRedundancy")]
        public PostPlannedFailoverRedundancy? PostPlannedFailoverRedundancy { get; }
    }
}
