// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Storage.Models
{
    public partial class GeoReplicationStatistics : IUtf8JsonSerializable, IJsonModel<GeoReplicationStatistics>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<GeoReplicationStatistics>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<GeoReplicationStatistics>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GeoReplicationStatistics>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(GeoReplicationStatistics)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(Status))
            {
                writer.WritePropertyName("status"u8);
                writer.WriteStringValue(Status.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(LastSyncOn))
            {
                writer.WritePropertyName("lastSyncTime"u8);
                writer.WriteStringValue(LastSyncOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(CanFailover))
            {
                writer.WritePropertyName("canFailover"u8);
                writer.WriteBooleanValue(CanFailover.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(CanPlannedFailover))
            {
                writer.WritePropertyName("canPlannedFailover"u8);
                writer.WriteBooleanValue(CanPlannedFailover.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(PostFailoverRedundancy))
            {
                writer.WritePropertyName("postFailoverRedundancy"u8);
                writer.WriteStringValue(PostFailoverRedundancy.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(PostPlannedFailoverRedundancy))
            {
                writer.WritePropertyName("postPlannedFailoverRedundancy"u8);
                writer.WriteStringValue(PostPlannedFailoverRedundancy.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        GeoReplicationStatistics IJsonModel<GeoReplicationStatistics>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GeoReplicationStatistics>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(GeoReplicationStatistics)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeGeoReplicationStatistics(document.RootElement, options);
        }

        internal static GeoReplicationStatistics DeserializeGeoReplicationStatistics(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            GeoReplicationStatus? status = default;
            DateTimeOffset? lastSyncTime = default;
            bool? canFailover = default;
            bool? canPlannedFailover = default;
            PostFailoverRedundancy? postFailoverRedundancy = default;
            PostPlannedFailoverRedundancy? postPlannedFailoverRedundancy = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("status"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    status = new GeoReplicationStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("lastSyncTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastSyncTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("canFailover"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    canFailover = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("canPlannedFailover"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    canPlannedFailover = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("postFailoverRedundancy"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    postFailoverRedundancy = new PostFailoverRedundancy(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("postPlannedFailoverRedundancy"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    postPlannedFailoverRedundancy = new PostPlannedFailoverRedundancy(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new GeoReplicationStatistics(
                status,
                lastSyncTime,
                canFailover,
                canPlannedFailover,
                postFailoverRedundancy,
                postPlannedFailoverRedundancy,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Status), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  status: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Status))
                {
                    builder.Append("  status: ");
                    builder.AppendLine($"'{Status.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastSyncOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  lastSyncTime: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastSyncOn))
                {
                    builder.Append("  lastSyncTime: ");
                    var formattedDateTimeString = TypeFormatters.ToString(LastSyncOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CanFailover), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  canFailover: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CanFailover))
                {
                    builder.Append("  canFailover: ");
                    var boolValue = CanFailover.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CanPlannedFailover), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  canPlannedFailover: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CanPlannedFailover))
                {
                    builder.Append("  canPlannedFailover: ");
                    var boolValue = CanPlannedFailover.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PostFailoverRedundancy), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  postFailoverRedundancy: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PostFailoverRedundancy))
                {
                    builder.Append("  postFailoverRedundancy: ");
                    builder.AppendLine($"'{PostFailoverRedundancy.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PostPlannedFailoverRedundancy), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  postPlannedFailoverRedundancy: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PostPlannedFailoverRedundancy))
                {
                    builder.Append("  postPlannedFailoverRedundancy: ");
                    builder.AppendLine($"'{PostPlannedFailoverRedundancy.Value.ToString()}'");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<GeoReplicationStatistics>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GeoReplicationStatistics>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(GeoReplicationStatistics)} does not support writing '{options.Format}' format.");
            }
        }

        GeoReplicationStatistics IPersistableModel<GeoReplicationStatistics>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GeoReplicationStatistics>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeGeoReplicationStatistics(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(GeoReplicationStatistics)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<GeoReplicationStatistics>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
