// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> The authentication protocol that is used for the file share. Can only be specified when creating a share. </summary>
    public readonly partial struct FileShareEnabledProtocol : IEquatable<FileShareEnabledProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FileShareEnabledProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FileShareEnabledProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SmbValue = "SMB";
        private const string NfsValue = "NFS";

        /// <summary> SMB. </summary>
        public static FileShareEnabledProtocol Smb { get; } = new FileShareEnabledProtocol(SmbValue);
        /// <summary> NFS. </summary>
        public static FileShareEnabledProtocol Nfs { get; } = new FileShareEnabledProtocol(NfsValue);
        /// <summary> Determines if two <see cref="FileShareEnabledProtocol"/> values are the same. </summary>
        public static bool operator ==(FileShareEnabledProtocol left, FileShareEnabledProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FileShareEnabledProtocol"/> values are not the same. </summary>
        public static bool operator !=(FileShareEnabledProtocol left, FileShareEnabledProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FileShareEnabledProtocol"/>. </summary>
        public static implicit operator FileShareEnabledProtocol(string value) => new FileShareEnabledProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FileShareEnabledProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FileShareEnabledProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
