// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Access tier for specific share. GpV2 account can choose between TransactionOptimized (default), Hot, and Cool. FileStorage account can choose Premium. </summary>
    public readonly partial struct FileShareAccessTier : IEquatable<FileShareAccessTier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="FileShareAccessTier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public FileShareAccessTier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TransactionOptimizedValue = "TransactionOptimized";
        private const string HotValue = "Hot";
        private const string CoolValue = "Cool";
        private const string PremiumValue = "Premium";

        /// <summary> TransactionOptimized. </summary>
        public static FileShareAccessTier TransactionOptimized { get; } = new FileShareAccessTier(TransactionOptimizedValue);
        /// <summary> Hot. </summary>
        public static FileShareAccessTier Hot { get; } = new FileShareAccessTier(HotValue);
        /// <summary> Cool. </summary>
        public static FileShareAccessTier Cool { get; } = new FileShareAccessTier(CoolValue);
        /// <summary> Premium. </summary>
        public static FileShareAccessTier Premium { get; } = new FileShareAccessTier(PremiumValue);
        /// <summary> Determines if two <see cref="FileShareAccessTier"/> values are the same. </summary>
        public static bool operator ==(FileShareAccessTier left, FileShareAccessTier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="FileShareAccessTier"/> values are not the same. </summary>
        public static bool operator !=(FileShareAccessTier left, FileShareAccessTier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="FileShareAccessTier"/>. </summary>
        public static implicit operator FileShareAccessTier(string value) => new FileShareAccessTier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is FileShareAccessTier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(FileShareAccessTier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
