// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Storage.Models
{
    public partial class ExecutionTriggerParametersUpdate : IUtf8JsonSerializable, IJsonModel<ExecutionTriggerParametersUpdate>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ExecutionTriggerParametersUpdate>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ExecutionTriggerParametersUpdate>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExecutionTriggerParametersUpdate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ExecutionTriggerParametersUpdate)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(StartFrom))
            {
                writer.WritePropertyName("startFrom"u8);
                writer.WriteStringValue(StartFrom.Value, "O");
            }
            if (Optional.IsDefined(Interval))
            {
                writer.WritePropertyName("interval"u8);
                writer.WriteNumberValue(Interval.Value);
            }
            if (Optional.IsDefined(IntervalUnit))
            {
                writer.WritePropertyName("intervalUnit"u8);
                writer.WriteStringValue(IntervalUnit.Value.ToString());
            }
            if (Optional.IsDefined(EndBy))
            {
                writer.WritePropertyName("endBy"u8);
                writer.WriteStringValue(EndBy.Value, "O");
            }
            if (Optional.IsDefined(StartOn))
            {
                writer.WritePropertyName("startOn"u8);
                writer.WriteStringValue(StartOn.Value, "O");
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ExecutionTriggerParametersUpdate IJsonModel<ExecutionTriggerParametersUpdate>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExecutionTriggerParametersUpdate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ExecutionTriggerParametersUpdate)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeExecutionTriggerParametersUpdate(document.RootElement, options);
        }

        internal static ExecutionTriggerParametersUpdate DeserializeExecutionTriggerParametersUpdate(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DateTimeOffset? startFrom = default;
            int? interval = default;
            ExecutionIntervalUnit? intervalUnit = default;
            DateTimeOffset? endBy = default;
            DateTimeOffset? startOn = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("startFrom"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    startFrom = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("interval"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    interval = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("intervalUnit"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    intervalUnit = new ExecutionIntervalUnit(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("endBy"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    endBy = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("startOn"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    startOn = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ExecutionTriggerParametersUpdate(
                startFrom,
                interval,
                intervalUnit,
                endBy,
                startOn,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ExecutionTriggerParametersUpdate>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExecutionTriggerParametersUpdate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ExecutionTriggerParametersUpdate)} does not support writing '{options.Format}' format.");
            }
        }

        ExecutionTriggerParametersUpdate IPersistableModel<ExecutionTriggerParametersUpdate>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExecutionTriggerParametersUpdate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeExecutionTriggerParametersUpdate(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ExecutionTriggerParametersUpdate)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ExecutionTriggerParametersUpdate>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
