// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Execution trigger for storage task assignment. </summary>
    public partial class ExecutionTrigger
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ExecutionTrigger"/>. </summary>
        /// <param name="triggerType"> The trigger type of the storage task assignment execution. </param>
        /// <param name="parameters"> The trigger parameters of the storage task assignment execution. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="parameters"/> is null. </exception>
        public ExecutionTrigger(ExecutionTriggerType triggerType, ExecutionTriggerParameters parameters)
        {
            Argument.AssertNotNull(parameters, nameof(parameters));

            TriggerType = triggerType;
            Parameters = parameters;
        }

        /// <summary> Initializes a new instance of <see cref="ExecutionTrigger"/>. </summary>
        /// <param name="triggerType"> The trigger type of the storage task assignment execution. </param>
        /// <param name="parameters"> The trigger parameters of the storage task assignment execution. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ExecutionTrigger(ExecutionTriggerType triggerType, ExecutionTriggerParameters parameters, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TriggerType = triggerType;
            Parameters = parameters;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ExecutionTrigger"/> for deserialization. </summary>
        internal ExecutionTrigger()
        {
        }

        /// <summary> The trigger type of the storage task assignment execution. </summary>
        [WirePath("type")]
        public ExecutionTriggerType TriggerType { get; set; }
        /// <summary> The trigger parameters of the storage task assignment execution. </summary>
        [WirePath("parameters")]
        public ExecutionTriggerParameters Parameters { get; set; }
    }
}
