// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Target helps provide filter parameters for the objects in the storage account and forms the execution context for the storage task. </summary>
    public partial class ExecutionTarget
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ExecutionTarget"/>. </summary>
        public ExecutionTarget()
        {
            Prefix = new ChangeTrackingList<string>();
            ExcludePrefix = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ExecutionTarget"/>. </summary>
        /// <param name="prefix"> Required list of object prefixes to be included for task execution. </param>
        /// <param name="excludePrefix"> List of object prefixes to be excluded from task execution. If there is a conflict between include and exclude prefixes, the exclude prefix will be the determining factor. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ExecutionTarget(IList<string> prefix, IList<string> excludePrefix, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Prefix = prefix;
            ExcludePrefix = excludePrefix;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Required list of object prefixes to be included for task execution. </summary>
        [WirePath("prefix")]
        public IList<string> Prefix { get; }
        /// <summary> List of object prefixes to be excluded from task execution. If there is a conflict between include and exclude prefixes, the exclude prefix will be the determining factor. </summary>
        [WirePath("excludePrefix")]
        public IList<string> ExcludePrefix { get; }
    }
}
