// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Run interval unit of task execution. This is a required field when ExecutionTrigger.properties.type is 'OnSchedule'; this property should not be present when ExecutionTrigger.properties.type is 'RunOnce'. </summary>
    public readonly partial struct ExecutionIntervalUnit : IEquatable<ExecutionIntervalUnit>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExecutionIntervalUnit"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExecutionIntervalUnit(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DaysValue = "Days";

        /// <summary> Days. </summary>
        public static ExecutionIntervalUnit Days { get; } = new ExecutionIntervalUnit(DaysValue);
        /// <summary> Determines if two <see cref="ExecutionIntervalUnit"/> values are the same. </summary>
        public static bool operator ==(ExecutionIntervalUnit left, ExecutionIntervalUnit right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExecutionIntervalUnit"/> values are not the same. </summary>
        public static bool operator !=(ExecutionIntervalUnit left, ExecutionIntervalUnit right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExecutionIntervalUnit"/>. </summary>
        public static implicit operator ExecutionIntervalUnit(string value) => new ExecutionIntervalUnit(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExecutionIntervalUnit other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExecutionIntervalUnit other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
