// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> The EncryptionScopesIncludeType. </summary>
    public readonly partial struct EncryptionScopesIncludeType : IEquatable<EncryptionScopesIncludeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EncryptionScopesIncludeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EncryptionScopesIncludeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllValue = "All";
        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> All. </summary>
        public static EncryptionScopesIncludeType All { get; } = new EncryptionScopesIncludeType(AllValue);
        /// <summary> Enabled. </summary>
        public static EncryptionScopesIncludeType Enabled { get; } = new EncryptionScopesIncludeType(EnabledValue);
        /// <summary> Disabled. </summary>
        public static EncryptionScopesIncludeType Disabled { get; } = new EncryptionScopesIncludeType(DisabledValue);
        /// <summary> Determines if two <see cref="EncryptionScopesIncludeType"/> values are the same. </summary>
        public static bool operator ==(EncryptionScopesIncludeType left, EncryptionScopesIncludeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EncryptionScopesIncludeType"/> values are not the same. </summary>
        public static bool operator !=(EncryptionScopesIncludeType left, EncryptionScopesIncludeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EncryptionScopesIncludeType"/>. </summary>
        public static implicit operator EncryptionScopesIncludeType(string value) => new EncryptionScopesIncludeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EncryptionScopesIncludeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EncryptionScopesIncludeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
