// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> The response from the List Deleted Accounts operation. </summary>
    internal partial class DeletedAccountListResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DeletedAccountListResult"/>. </summary>
        internal DeletedAccountListResult()
        {
            Value = new ChangeTrackingList<DeletedAccountData>();
        }

        /// <summary> Initializes a new instance of <see cref="DeletedAccountListResult"/>. </summary>
        /// <param name="value"> Gets the list of deleted accounts and their properties. </param>
        /// <param name="nextLink"> Request URL that can be used to query next page of deleted accounts. Returned when total number of requested deleted accounts exceed maximum page size. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DeletedAccountListResult(IReadOnlyList<DeletedAccountData> value, string nextLink, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Value = value;
            NextLink = nextLink;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the list of deleted accounts and their properties. </summary>
        public IReadOnlyList<DeletedAccountData> Value { get; }
        /// <summary> Request URL that can be used to query next page of deleted accounts. Returned when total number of requested deleted accounts exceed maximum page size. </summary>
        public string NextLink { get; }
    }
}
