// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Default share permission for users using Kerberos authentication if RBAC role is not assigned. </summary>
    public readonly partial struct DefaultSharePermission : IEquatable<DefaultSharePermission>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DefaultSharePermission"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DefaultSharePermission(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string ReaderValue = "StorageFileDataSmbShareReader";
        private const string ContributorValue = "StorageFileDataSmbShareContributor";
        private const string ElevatedContributorValue = "StorageFileDataSmbShareElevatedContributor";

        /// <summary> None. </summary>
        public static DefaultSharePermission None { get; } = new DefaultSharePermission(NoneValue);
        /// <summary> StorageFileDataSmbShareReader. </summary>
        public static DefaultSharePermission Reader { get; } = new DefaultSharePermission(ReaderValue);
        /// <summary> StorageFileDataSmbShareContributor. </summary>
        public static DefaultSharePermission Contributor { get; } = new DefaultSharePermission(ContributorValue);
        /// <summary> StorageFileDataSmbShareElevatedContributor. </summary>
        public static DefaultSharePermission ElevatedContributor { get; } = new DefaultSharePermission(ElevatedContributorValue);
        /// <summary> Determines if two <see cref="DefaultSharePermission"/> values are the same. </summary>
        public static bool operator ==(DefaultSharePermission left, DefaultSharePermission right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DefaultSharePermission"/> values are not the same. </summary>
        public static bool operator !=(DefaultSharePermission left, DefaultSharePermission right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DefaultSharePermission"/>. </summary>
        public static implicit operator DefaultSharePermission(string value) => new DefaultSharePermission(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DefaultSharePermission other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DefaultSharePermission other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
