// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> The CorsRuleAllowedMethod. </summary>
    public readonly partial struct CorsRuleAllowedMethod : IEquatable<CorsRuleAllowedMethod>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CorsRuleAllowedMethod"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CorsRuleAllowedMethod(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DeleteValue = "DELETE";
        private const string GetValue = "GET";
        private const string HeadValue = "HEAD";
        private const string MergeValue = "MERGE";
        private const string PostValue = "POST";
        private const string OptionsValue = "OPTIONS";
        private const string PutValue = "PUT";
        private const string PatchValue = "PATCH";
        private const string ConnectValue = "CONNECT";
        private const string TraceValue = "TRACE";

        /// <summary> DELETE. </summary>
        public static CorsRuleAllowedMethod Delete { get; } = new CorsRuleAllowedMethod(DeleteValue);
        /// <summary> GET. </summary>
        public static CorsRuleAllowedMethod Get { get; } = new CorsRuleAllowedMethod(GetValue);
        /// <summary> HEAD. </summary>
        public static CorsRuleAllowedMethod Head { get; } = new CorsRuleAllowedMethod(HeadValue);
        /// <summary> MERGE. </summary>
        public static CorsRuleAllowedMethod Merge { get; } = new CorsRuleAllowedMethod(MergeValue);
        /// <summary> POST. </summary>
        public static CorsRuleAllowedMethod Post { get; } = new CorsRuleAllowedMethod(PostValue);
        /// <summary> OPTIONS. </summary>
        public static CorsRuleAllowedMethod Options { get; } = new CorsRuleAllowedMethod(OptionsValue);
        /// <summary> PUT. </summary>
        public static CorsRuleAllowedMethod Put { get; } = new CorsRuleAllowedMethod(PutValue);
        /// <summary> PATCH. </summary>
        public static CorsRuleAllowedMethod Patch { get; } = new CorsRuleAllowedMethod(PatchValue);
        /// <summary> CONNECT. </summary>
        public static CorsRuleAllowedMethod Connect { get; } = new CorsRuleAllowedMethod(ConnectValue);
        /// <summary> TRACE. </summary>
        public static CorsRuleAllowedMethod Trace { get; } = new CorsRuleAllowedMethod(TraceValue);
        /// <summary> Determines if two <see cref="CorsRuleAllowedMethod"/> values are the same. </summary>
        public static bool operator ==(CorsRuleAllowedMethod left, CorsRuleAllowedMethod right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CorsRuleAllowedMethod"/> values are not the same. </summary>
        public static bool operator !=(CorsRuleAllowedMethod left, CorsRuleAllowedMethod right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CorsRuleAllowedMethod"/>. </summary>
        public static implicit operator CorsRuleAllowedMethod(string value) => new CorsRuleAllowedMethod(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CorsRuleAllowedMethod other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CorsRuleAllowedMethod other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
