// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> The valid value is Inventory. </summary>
    public readonly partial struct BlobInventoryRuleType : IEquatable<BlobInventoryRuleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BlobInventoryRuleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BlobInventoryRuleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InventoryValue = "Inventory";

        /// <summary> Inventory. </summary>
        public static BlobInventoryRuleType Inventory { get; } = new BlobInventoryRuleType(InventoryValue);
        /// <summary> Determines if two <see cref="BlobInventoryRuleType"/> values are the same. </summary>
        public static bool operator ==(BlobInventoryRuleType left, BlobInventoryRuleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BlobInventoryRuleType"/> values are not the same. </summary>
        public static bool operator !=(BlobInventoryRuleType left, BlobInventoryRuleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BlobInventoryRuleType"/>. </summary>
        public static implicit operator BlobInventoryRuleType(string value) => new BlobInventoryRuleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BlobInventoryRuleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BlobInventoryRuleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
