// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> This is a required field. This field specifies the scope of the inventory created either at the blob or container level. </summary>
    public readonly partial struct BlobInventoryPolicyObjectType : IEquatable<BlobInventoryPolicyObjectType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BlobInventoryPolicyObjectType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BlobInventoryPolicyObjectType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BlobValue = "Blob";
        private const string ContainerValue = "Container";

        /// <summary> Blob. </summary>
        public static BlobInventoryPolicyObjectType Blob { get; } = new BlobInventoryPolicyObjectType(BlobValue);
        /// <summary> Container. </summary>
        public static BlobInventoryPolicyObjectType Container { get; } = new BlobInventoryPolicyObjectType(ContainerValue);
        /// <summary> Determines if two <see cref="BlobInventoryPolicyObjectType"/> values are the same. </summary>
        public static bool operator ==(BlobInventoryPolicyObjectType left, BlobInventoryPolicyObjectType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BlobInventoryPolicyObjectType"/> values are not the same. </summary>
        public static bool operator !=(BlobInventoryPolicyObjectType left, BlobInventoryPolicyObjectType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BlobInventoryPolicyObjectType"/>. </summary>
        public static implicit operator BlobInventoryPolicyObjectType(string value) => new BlobInventoryPolicyObjectType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BlobInventoryPolicyObjectType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BlobInventoryPolicyObjectType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
