// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> An object that defines the blob inventory rule filter conditions. For 'Blob' definition.objectType all filter properties are applicable, 'blobTypes' is required and others are optional. For 'Container' definition.objectType only prefixMatch is applicable and is optional. </summary>
    public partial class BlobInventoryPolicyFilter
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BlobInventoryPolicyFilter"/>. </summary>
        public BlobInventoryPolicyFilter()
        {
            IncludePrefix = new ChangeTrackingList<string>();
            ExcludePrefix = new ChangeTrackingList<string>();
            BlobTypes = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="BlobInventoryPolicyFilter"/>. </summary>
        /// <param name="includePrefix"> An array of strings with maximum 10 blob prefixes to be included in the inventory. </param>
        /// <param name="excludePrefix"> An array of strings with maximum 10 blob prefixes to be excluded from the inventory. </param>
        /// <param name="blobTypes"> An array of predefined enum values. Valid values include blockBlob, appendBlob, pageBlob. Hns accounts does not support pageBlobs. This field is required when definition.objectType property is set to 'Blob'. </param>
        /// <param name="includeBlobVersions"> Includes blob versions in blob inventory when value is set to true. The definition.schemaFields values 'VersionId and IsCurrentVersion' are required if this property is set to true, else they must be excluded. </param>
        /// <param name="includeSnapshots"> Includes blob snapshots in blob inventory when value is set to true. The definition.schemaFields value 'Snapshot' is required if this property is set to true, else it must be excluded. </param>
        /// <param name="includeDeleted"> For 'Container' definition.objectType the definition.schemaFields must include 'Deleted, Version, DeletedTime and RemainingRetentionDays'. For 'Blob' definition.objectType and HNS enabled storage accounts the definition.schemaFields must include 'DeletionId, Deleted, DeletedTime and RemainingRetentionDays' and for Hns disabled accounts the definition.schemaFields must include 'Deleted and RemainingRetentionDays', else it must be excluded. </param>
        /// <param name="creationTime"> This property is used to filter objects based on the object creation time. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BlobInventoryPolicyFilter(IList<string> includePrefix, IList<string> excludePrefix, IList<string> blobTypes, bool? includeBlobVersions, bool? includeSnapshots, bool? includeDeleted, BlobInventoryCreationTime creationTime, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IncludePrefix = includePrefix;
            ExcludePrefix = excludePrefix;
            BlobTypes = blobTypes;
            IncludeBlobVersions = includeBlobVersions;
            IncludeSnapshots = includeSnapshots;
            IncludeDeleted = includeDeleted;
            CreationTime = creationTime;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> An array of strings with maximum 10 blob prefixes to be included in the inventory. </summary>
        [WirePath("prefixMatch")]
        public IList<string> IncludePrefix { get; }
        /// <summary> An array of strings with maximum 10 blob prefixes to be excluded from the inventory. </summary>
        [WirePath("excludePrefix")]
        public IList<string> ExcludePrefix { get; }
        /// <summary> An array of predefined enum values. Valid values include blockBlob, appendBlob, pageBlob. Hns accounts does not support pageBlobs. This field is required when definition.objectType property is set to 'Blob'. </summary>
        [WirePath("blobTypes")]
        public IList<string> BlobTypes { get; }
        /// <summary> Includes blob versions in blob inventory when value is set to true. The definition.schemaFields values 'VersionId and IsCurrentVersion' are required if this property is set to true, else they must be excluded. </summary>
        [WirePath("includeBlobVersions")]
        public bool? IncludeBlobVersions { get; set; }
        /// <summary> Includes blob snapshots in blob inventory when value is set to true. The definition.schemaFields value 'Snapshot' is required if this property is set to true, else it must be excluded. </summary>
        [WirePath("includeSnapshots")]
        public bool? IncludeSnapshots { get; set; }
        /// <summary> For 'Container' definition.objectType the definition.schemaFields must include 'Deleted, Version, DeletedTime and RemainingRetentionDays'. For 'Blob' definition.objectType and HNS enabled storage accounts the definition.schemaFields must include 'DeletionId, Deleted, DeletedTime and RemainingRetentionDays' and for Hns disabled accounts the definition.schemaFields must include 'Deleted and RemainingRetentionDays', else it must be excluded. </summary>
        [WirePath("includeDeleted")]
        public bool? IncludeDeleted { get; set; }
        /// <summary> This property is used to filter objects based on the object creation time. </summary>
        internal BlobInventoryCreationTime CreationTime { get; set; }
        /// <summary> When set the policy filters the objects that are created in the last N days. Where N is an integer value between 1 to 36500. </summary>
        [WirePath("creationTime.lastNDays")]
        public int? CreationTimeLastNDays
        {
            get => CreationTime is null ? default : CreationTime.LastNDays;
            set
            {
                if (CreationTime is null)
                    CreationTime = new BlobInventoryCreationTime();
                CreationTime.LastNDays = value;
            }
        }
    }
}
