// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> The BlobContainerState. </summary>
    public readonly partial struct BlobContainerState : IEquatable<BlobContainerState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BlobContainerState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BlobContainerState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DeletedValue = "deleted";

        /// <summary> deleted. </summary>
        public static BlobContainerState Deleted { get; } = new BlobContainerState(DeletedValue);
        /// <summary> Determines if two <see cref="BlobContainerState"/> values are the same. </summary>
        public static bool operator ==(BlobContainerState left, BlobContainerState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BlobContainerState"/> values are not the same. </summary>
        public static bool operator !=(BlobContainerState left, BlobContainerState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BlobContainerState"/>. </summary>
        public static implicit operator BlobContainerState(string value) => new BlobContainerState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BlobContainerState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BlobContainerState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
