// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Restrict copy to and from Storage Accounts within an AAD tenant or with Private Links to the same VNet. </summary>
    public readonly partial struct AllowedCopyScope : IEquatable<AllowedCopyScope>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AllowedCopyScope"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AllowedCopyScope(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PrivateLinkValue = "PrivateLink";
        private const string AadValue = "AAD";

        /// <summary> PrivateLink. </summary>
        public static AllowedCopyScope PrivateLink { get; } = new AllowedCopyScope(PrivateLinkValue);
        /// <summary> AAD. </summary>
        public static AllowedCopyScope Aad { get; } = new AllowedCopyScope(AadValue);
        /// <summary> Determines if two <see cref="AllowedCopyScope"/> values are the same. </summary>
        public static bool operator ==(AllowedCopyScope left, AllowedCopyScope right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AllowedCopyScope"/> values are not the same. </summary>
        public static bool operator !=(AllowedCopyScope left, AllowedCopyScope right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AllowedCopyScope"/>. </summary>
        public static implicit operator AllowedCopyScope(string value) => new AllowedCopyScope(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AllowedCopyScope other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AllowedCopyScope other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
