// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> Specifies the Active Directory account type for Azure Storage. </summary>
    public readonly partial struct ActiveDirectoryAccountType : IEquatable<ActiveDirectoryAccountType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ActiveDirectoryAccountType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ActiveDirectoryAccountType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UserValue = "User";
        private const string ComputerValue = "Computer";

        /// <summary> User. </summary>
        public static ActiveDirectoryAccountType User { get; } = new ActiveDirectoryAccountType(UserValue);
        /// <summary> Computer. </summary>
        public static ActiveDirectoryAccountType Computer { get; } = new ActiveDirectoryAccountType(ComputerValue);
        /// <summary> Determines if two <see cref="ActiveDirectoryAccountType"/> values are the same. </summary>
        public static bool operator ==(ActiveDirectoryAccountType left, ActiveDirectoryAccountType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ActiveDirectoryAccountType"/> values are not the same. </summary>
        public static bool operator !=(ActiveDirectoryAccountType left, ActiveDirectoryAccountType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ActiveDirectoryAccountType"/>. </summary>
        public static implicit operator ActiveDirectoryAccountType(string value) => new ActiveDirectoryAccountType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ActiveDirectoryAccountType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ActiveDirectoryAccountType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
