// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Storage.Models
{
    /// <summary> The parameters to list SAS credentials of a storage account. </summary>
    public partial class AccountSasContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AccountSasContent"/>. </summary>
        /// <param name="services"> The signed services accessible with the account SAS. Possible values include: Blob (b), Queue (q), Table (t), File (f). </param>
        /// <param name="resourceTypes"> The signed resource types that are accessible with the account SAS. Service (s): Access to service-level APIs; Container (c): Access to container-level APIs; Object (o): Access to object-level APIs for blobs, queue messages, table entities, and files. </param>
        /// <param name="permissions"> The signed permissions for the account SAS. Possible values include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p). </param>
        /// <param name="sharedAccessExpireOn"> The time at which the shared access signature becomes invalid. </param>
        public AccountSasContent(StorageAccountSasSignedService services, StorageAccountSasSignedResourceType resourceTypes, StorageAccountSasPermission permissions, DateTimeOffset sharedAccessExpireOn)
        {
            Services = services;
            ResourceTypes = resourceTypes;
            Permissions = permissions;
            SharedAccessExpireOn = sharedAccessExpireOn;
        }

        /// <summary> Initializes a new instance of <see cref="AccountSasContent"/>. </summary>
        /// <param name="services"> The signed services accessible with the account SAS. Possible values include: Blob (b), Queue (q), Table (t), File (f). </param>
        /// <param name="resourceTypes"> The signed resource types that are accessible with the account SAS. Service (s): Access to service-level APIs; Container (c): Access to container-level APIs; Object (o): Access to object-level APIs for blobs, queue messages, table entities, and files. </param>
        /// <param name="permissions"> The signed permissions for the account SAS. Possible values include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p). </param>
        /// <param name="ipAddressOrRange"> An IP address or a range of IP addresses from which to accept requests. </param>
        /// <param name="protocols"> The protocol permitted for a request made with the account SAS. </param>
        /// <param name="sharedAccessStartOn"> The time at which the SAS becomes valid. </param>
        /// <param name="sharedAccessExpireOn"> The time at which the shared access signature becomes invalid. </param>
        /// <param name="keyToSign"> The key to sign the account SAS token with. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AccountSasContent(StorageAccountSasSignedService services, StorageAccountSasSignedResourceType resourceTypes, StorageAccountSasPermission permissions, string ipAddressOrRange, StorageAccountHttpProtocol? protocols, DateTimeOffset? sharedAccessStartOn, DateTimeOffset sharedAccessExpireOn, string keyToSign, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Services = services;
            ResourceTypes = resourceTypes;
            Permissions = permissions;
            IPAddressOrRange = ipAddressOrRange;
            Protocols = protocols;
            SharedAccessStartOn = sharedAccessStartOn;
            SharedAccessExpireOn = sharedAccessExpireOn;
            KeyToSign = keyToSign;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AccountSasContent"/> for deserialization. </summary>
        internal AccountSasContent()
        {
        }

        /// <summary> The signed services accessible with the account SAS. Possible values include: Blob (b), Queue (q), Table (t), File (f). </summary>
        [WirePath("signedServices")]
        public StorageAccountSasSignedService Services { get; }
        /// <summary> The signed resource types that are accessible with the account SAS. Service (s): Access to service-level APIs; Container (c): Access to container-level APIs; Object (o): Access to object-level APIs for blobs, queue messages, table entities, and files. </summary>
        [WirePath("signedResourceTypes")]
        public StorageAccountSasSignedResourceType ResourceTypes { get; }
        /// <summary> The signed permissions for the account SAS. Possible values include: Read (r), Write (w), Delete (d), List (l), Add (a), Create (c), Update (u) and Process (p). </summary>
        [WirePath("signedPermission")]
        public StorageAccountSasPermission Permissions { get; }
        /// <summary> An IP address or a range of IP addresses from which to accept requests. </summary>
        [WirePath("signedIp")]
        public string IPAddressOrRange { get; set; }
        /// <summary> The protocol permitted for a request made with the account SAS. </summary>
        [WirePath("signedProtocol")]
        public StorageAccountHttpProtocol? Protocols { get; set; }
        /// <summary> The time at which the SAS becomes valid. </summary>
        [WirePath("signedStart")]
        public DateTimeOffset? SharedAccessStartOn { get; set; }
        /// <summary> The time at which the shared access signature becomes invalid. </summary>
        [WirePath("signedExpiry")]
        public DateTimeOffset SharedAccessExpireOn { get; }
        /// <summary> The key to sign the account SAS token with. </summary>
        [WirePath("keyToSign")]
        public string KeyToSign { get; set; }
    }
}
