// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Storage
{
    internal class StorageTaskAssignmentOperationSource : IOperationSource<StorageTaskAssignmentResource>
    {
        private readonly ArmClient _client;

        internal StorageTaskAssignmentOperationSource(ArmClient client)
        {
            _client = client;
        }

        StorageTaskAssignmentResource IOperationSource<StorageTaskAssignmentResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = StorageTaskAssignmentData.DeserializeStorageTaskAssignmentData(document.RootElement);
            return new StorageTaskAssignmentResource(_client, data);
        }

        async ValueTask<StorageTaskAssignmentResource> IOperationSource<StorageTaskAssignmentResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = StorageTaskAssignmentData.DeserializeStorageTaskAssignmentData(document.RootElement);
            return new StorageTaskAssignmentResource(_client, data);
        }
    }
}
