// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Storage.Models;

namespace Azure.ResourceManager.Storage
{
    /// <summary>
    /// A class representing the FileShare data model.
    /// Properties of the file share, including Id, resource name, resource type, Etag.
    /// </summary>
    public partial class FileShareData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FileShareData"/>. </summary>
        public FileShareData()
        {
            Metadata = new ChangeTrackingDictionary<string, string>();
            SignedIdentifiers = new ChangeTrackingList<StorageSignedIdentifier>();
        }

        /// <summary> Initializes a new instance of <see cref="FileShareData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="lastModifiedOn"> Returns the date and time the share was last modified. </param>
        /// <param name="metadata"> A name-value pair to associate with the share as metadata. </param>
        /// <param name="shareQuota"> The maximum size of the share, in gigabytes. Must be greater than 0, and less than or equal to 5TB (5120). For Large File Shares, the maximum size is 102400. </param>
        /// <param name="enabledProtocol"> The authentication protocol that is used for the file share. Can only be specified when creating a share. </param>
        /// <param name="rootSquash"> The property is for NFS share only. The default is NoRootSquash. </param>
        /// <param name="version"> The version of the share. </param>
        /// <param name="isDeleted"> Indicates whether the share was deleted. </param>
        /// <param name="deletedOn"> The deleted time if the share was deleted. </param>
        /// <param name="remainingRetentionDays"> Remaining retention days for share that was soft deleted. </param>
        /// <param name="accessTier"> Access tier for specific share. GpV2 account can choose between TransactionOptimized (default), Hot, and Cool. FileStorage account can choose Premium. </param>
        /// <param name="accessTierChangeOn"> Indicates the last modification time for share access tier. </param>
        /// <param name="accessTierStatus"> Indicates if there is a pending transition for access tier. </param>
        /// <param name="shareUsageBytes"> The approximate size of the data stored on the share. Note that this value may not include all recently created or recently resized files. </param>
        /// <param name="leaseStatus"> The lease status of the share. </param>
        /// <param name="leaseState"> Lease state of the share. </param>
        /// <param name="leaseDuration"> Specifies whether the lease on a share is of infinite or fixed duration, only when the share is leased. </param>
        /// <param name="signedIdentifiers"> List of stored access policies specified on the share. </param>
        /// <param name="snapshotOn"> Creation time of share snapshot returned in the response of list shares with expand param "snapshots". </param>
        /// <param name="etag"> Resource Etag. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FileShareData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DateTimeOffset? lastModifiedOn, IDictionary<string, string> metadata, int? shareQuota, FileShareEnabledProtocol? enabledProtocol, RootSquashType? rootSquash, string version, bool? isDeleted, DateTimeOffset? deletedOn, int? remainingRetentionDays, FileShareAccessTier? accessTier, DateTimeOffset? accessTierChangeOn, string accessTierStatus, long? shareUsageBytes, StorageLeaseStatus? leaseStatus, StorageLeaseState? leaseState, StorageLeaseDurationType? leaseDuration, IList<StorageSignedIdentifier> signedIdentifiers, DateTimeOffset? snapshotOn, ETag? etag, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            LastModifiedOn = lastModifiedOn;
            Metadata = metadata;
            ShareQuota = shareQuota;
            EnabledProtocol = enabledProtocol;
            RootSquash = rootSquash;
            Version = version;
            IsDeleted = isDeleted;
            DeletedOn = deletedOn;
            RemainingRetentionDays = remainingRetentionDays;
            AccessTier = accessTier;
            AccessTierChangeOn = accessTierChangeOn;
            AccessTierStatus = accessTierStatus;
            ShareUsageBytes = shareUsageBytes;
            LeaseStatus = leaseStatus;
            LeaseState = leaseState;
            LeaseDuration = leaseDuration;
            SignedIdentifiers = signedIdentifiers;
            SnapshotOn = snapshotOn;
            ETag = etag;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Returns the date and time the share was last modified. </summary>
        [WirePath("properties.lastModifiedTime")]
        public DateTimeOffset? LastModifiedOn { get; }
        /// <summary> A name-value pair to associate with the share as metadata. </summary>
        [WirePath("properties.metadata")]
        public IDictionary<string, string> Metadata { get; }
        /// <summary> The maximum size of the share, in gigabytes. Must be greater than 0, and less than or equal to 5TB (5120). For Large File Shares, the maximum size is 102400. </summary>
        [WirePath("properties.shareQuota")]
        public int? ShareQuota { get; set; }
        /// <summary> The authentication protocol that is used for the file share. Can only be specified when creating a share. </summary>
        [WirePath("properties.enabledProtocols")]
        public FileShareEnabledProtocol? EnabledProtocol { get; set; }
        /// <summary> The property is for NFS share only. The default is NoRootSquash. </summary>
        [WirePath("properties.rootSquash")]
        public RootSquashType? RootSquash { get; set; }
        /// <summary> The version of the share. </summary>
        [WirePath("properties.version")]
        public string Version { get; }
        /// <summary> Indicates whether the share was deleted. </summary>
        [WirePath("properties.deleted")]
        public bool? IsDeleted { get; }
        /// <summary> The deleted time if the share was deleted. </summary>
        [WirePath("properties.deletedTime")]
        public DateTimeOffset? DeletedOn { get; }
        /// <summary> Remaining retention days for share that was soft deleted. </summary>
        [WirePath("properties.remainingRetentionDays")]
        public int? RemainingRetentionDays { get; }
        /// <summary> Access tier for specific share. GpV2 account can choose between TransactionOptimized (default), Hot, and Cool. FileStorage account can choose Premium. </summary>
        [WirePath("properties.accessTier")]
        public FileShareAccessTier? AccessTier { get; set; }
        /// <summary> Indicates the last modification time for share access tier. </summary>
        [WirePath("properties.accessTierChangeTime")]
        public DateTimeOffset? AccessTierChangeOn { get; }
        /// <summary> Indicates if there is a pending transition for access tier. </summary>
        [WirePath("properties.accessTierStatus")]
        public string AccessTierStatus { get; }
        /// <summary> The approximate size of the data stored on the share. Note that this value may not include all recently created or recently resized files. </summary>
        [WirePath("properties.shareUsageBytes")]
        public long? ShareUsageBytes { get; }
        /// <summary> The lease status of the share. </summary>
        [WirePath("properties.leaseStatus")]
        public StorageLeaseStatus? LeaseStatus { get; }
        /// <summary> Lease state of the share. </summary>
        [WirePath("properties.leaseState")]
        public StorageLeaseState? LeaseState { get; }
        /// <summary> Specifies whether the lease on a share is of infinite or fixed duration, only when the share is leased. </summary>
        [WirePath("properties.leaseDuration")]
        public StorageLeaseDurationType? LeaseDuration { get; }
        /// <summary> List of stored access policies specified on the share. </summary>
        [WirePath("properties.signedIdentifiers")]
        public IList<StorageSignedIdentifier> SignedIdentifiers { get; }
        /// <summary> Creation time of share snapshot returned in the response of list shares with expand param "snapshots". </summary>
        [WirePath("properties.snapshotTime")]
        public DateTimeOffset? SnapshotOn { get; }
        /// <summary> Resource Etag. </summary>
        [WirePath("etag")]
        public ETag? ETag { get; }
    }
}
