// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Storage.Models;

namespace Azure.ResourceManager.Storage
{
    /// <summary>
    /// A class representing the EncryptionScope data model.
    /// The Encryption Scope resource.
    /// </summary>
    public partial class EncryptionScopeData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EncryptionScopeData"/>. </summary>
        public EncryptionScopeData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="EncryptionScopeData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="source"> The provider for the encryption scope. Possible values (case-insensitive):  Microsoft.Storage, Microsoft.KeyVault. </param>
        /// <param name="state"> The state of the encryption scope. Possible values (case-insensitive):  Enabled, Disabled. </param>
        /// <param name="createdOn"> Gets the creation date and time of the encryption scope in UTC. </param>
        /// <param name="lastModifiedOn"> Gets the last modification date and time of the encryption scope in UTC. </param>
        /// <param name="keyVaultProperties"> The key vault properties for the encryption scope. This is a required field if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'. </param>
        /// <param name="requireInfrastructureEncryption"> A boolean indicating whether or not the service applies a secondary layer of encryption with platform managed keys for data at rest. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EncryptionScopeData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, EncryptionScopeSource? source, EncryptionScopeState? state, DateTimeOffset? createdOn, DateTimeOffset? lastModifiedOn, EncryptionScopeKeyVaultProperties keyVaultProperties, bool? requireInfrastructureEncryption, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Source = source;
            State = state;
            CreatedOn = createdOn;
            LastModifiedOn = lastModifiedOn;
            KeyVaultProperties = keyVaultProperties;
            RequireInfrastructureEncryption = requireInfrastructureEncryption;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The provider for the encryption scope. Possible values (case-insensitive):  Microsoft.Storage, Microsoft.KeyVault. </summary>
        [WirePath("properties.source")]
        public EncryptionScopeSource? Source { get; set; }
        /// <summary> The state of the encryption scope. Possible values (case-insensitive):  Enabled, Disabled. </summary>
        [WirePath("properties.state")]
        public EncryptionScopeState? State { get; set; }
        /// <summary> Gets the creation date and time of the encryption scope in UTC. </summary>
        [WirePath("properties.creationTime")]
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> Gets the last modification date and time of the encryption scope in UTC. </summary>
        [WirePath("properties.lastModifiedTime")]
        public DateTimeOffset? LastModifiedOn { get; }
        /// <summary> The key vault properties for the encryption scope. This is a required field if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'. </summary>
        [WirePath("properties.keyVaultProperties")]
        public EncryptionScopeKeyVaultProperties KeyVaultProperties { get; set; }
        /// <summary> A boolean indicating whether or not the service applies a secondary layer of encryption with platform managed keys for data at rest. </summary>
        [WirePath("properties.requireInfrastructureEncryption")]
        public bool? RequireInfrastructureEncryption { get; set; }
    }
}
