// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Storage
{
    /// <summary>
    /// A class representing a collection of <see cref="StorageQueueResource"/> and their operations.
    /// Each <see cref="StorageQueueResource"/> in the collection will belong to the same instance of <see cref="QueueServiceResource"/>.
    /// To get a <see cref="StorageQueueCollection"/> instance call the GetStorageQueues method from an instance of <see cref="QueueServiceResource"/>.
    /// </summary>
    public partial class StorageQueueCollection : ArmCollection, IEnumerable<StorageQueueResource>, IAsyncEnumerable<StorageQueueResource>
    {
        /// <summary>
        /// Gets a list of all the queues under the specified storage account
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/queueServices/default/queues</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Queue_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StorageQueueResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="maxpagesize"> Optional, a maximum number of queues that should be included in a list queue response. </param>
        /// <param name="filter"> Optional, When specified, only the queues with a name starting with the given filter will be listed. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="StorageQueueResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<StorageQueueResource> GetAllAsync(string maxpagesize, string filter, CancellationToken cancellationToken)
            => GetAllAsync(string.IsNullOrEmpty(maxpagesize) ? null : int.Parse(maxpagesize), filter, cancellationToken);

        /// <summary>
        /// Gets a list of all the queues under the specified storage account
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/queueServices/default/queues</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Queue_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-09-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StorageQueueResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="maxpagesize"> Optional, a maximum number of queues that should be included in a list queue response. </param>
        /// <param name="filter"> Optional, When specified, only the queues with a name starting with the given filter will be listed. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="StorageQueueResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<StorageQueueResource> GetAll(string maxpagesize, string filter, CancellationToken cancellationToken)
            => GetAll(string.IsNullOrEmpty(maxpagesize) ? null : int.Parse(maxpagesize), filter, cancellationToken);
    }
}
