// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Storage.Models;

namespace Azure.ResourceManager.Storage.Samples
{
    public partial class Sample_StorageTaskAssignmentResource
    {
        // PatchStorageTaskAssignment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_PatchStorageTaskAssignment()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/storageTaskAssignmentsCrud/PatchStorageTaskAssignment.json
            // this example is just showing the usage of "StorageTaskAssignments_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageTaskAssignmentResource created on azure
            // for more information of creating StorageTaskAssignmentResource, please refer to the document of StorageTaskAssignmentResource
            string subscriptionId = "1f31ba14-ce16-4281-b9b4-3e78da6e1616";
            string resourceGroupName = "res4228";
            string accountName = "sto4445";
            string storageTaskAssignmentName = "myassignment1";
            ResourceIdentifier storageTaskAssignmentResourceId = StorageTaskAssignmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, storageTaskAssignmentName);
            StorageTaskAssignmentResource storageTaskAssignment = client.GetStorageTaskAssignmentResource(storageTaskAssignmentResourceId);

            // invoke the operation
            StorageTaskAssignmentPatch patch = new StorageTaskAssignmentPatch()
            {
                Properties = new StorageTaskAssignmentPatchProperties()
                {
                    IsEnabled = true,
                    Description = "My Storage task assignment",
                    ExecutionContext = new StorageTaskAssignmentUpdateExecutionContext()
                    {
                        Target = new ExecutionTarget()
                        {
                            Prefix =
{
"prefix1","prefix2"
},
                            ExcludePrefix =
{
},
                        },
                        Trigger = new ExecutionTriggerUpdate()
                        {
                            TriggerType = ExecutionTriggerType.RunOnce,
                            Parameters = new ExecutionTriggerParametersUpdate()
                            {
                                StartOn = DateTimeOffset.Parse("2022-11-15T21:52:47.8145095Z"),
                            },
                        },
                    },
                    ReportPrefix = "container1",
                },
            };
            ArmOperation<StorageTaskAssignmentResource> lro = await storageTaskAssignment.UpdateAsync(WaitUntil.Completed, patch);
            StorageTaskAssignmentResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StorageTaskAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // GetStorageTaskAssignment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetStorageTaskAssignment()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/storageTaskAssignmentsCrud/GetStorageTaskAssignment.json
            // this example is just showing the usage of "StorageTaskAssignments_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageTaskAssignmentResource created on azure
            // for more information of creating StorageTaskAssignmentResource, please refer to the document of StorageTaskAssignmentResource
            string subscriptionId = "1f31ba14-ce16-4281-b9b4-3e78da6e1616";
            string resourceGroupName = "res4228";
            string accountName = "sto4445";
            string storageTaskAssignmentName = "myassignment1";
            ResourceIdentifier storageTaskAssignmentResourceId = StorageTaskAssignmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, storageTaskAssignmentName);
            StorageTaskAssignmentResource storageTaskAssignment = client.GetStorageTaskAssignmentResource(storageTaskAssignmentResourceId);

            // invoke the operation
            StorageTaskAssignmentResource result = await storageTaskAssignment.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StorageTaskAssignmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // DeleteStorageTaskAssignment
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteStorageTaskAssignment()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/storageTaskAssignmentsCrud/DeleteStorageTaskAssignment.json
            // this example is just showing the usage of "StorageTaskAssignments_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageTaskAssignmentResource created on azure
            // for more information of creating StorageTaskAssignmentResource, please refer to the document of StorageTaskAssignmentResource
            string subscriptionId = "1f31ba14-ce16-4281-b9b4-3e78da6e1616";
            string resourceGroupName = "res4228";
            string accountName = "sto4445";
            string storageTaskAssignmentName = "myassignment1";
            ResourceIdentifier storageTaskAssignmentResourceId = StorageTaskAssignmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, storageTaskAssignmentName);
            StorageTaskAssignmentResource storageTaskAssignment = client.GetStorageTaskAssignmentResource(storageTaskAssignmentResourceId);

            // invoke the operation
            await storageTaskAssignment.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // ListStorageTaskAssignmentInstancesReportSummary
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetStorageTaskAssignmentInstancesReports_ListStorageTaskAssignmentInstancesReportSummary()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/storageTaskAssignmentsList/ListStorageTaskAssignmentInstancesReportSummary.json
            // this example is just showing the usage of "StorageTaskAssignmentInstancesReport_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageTaskAssignmentResource created on azure
            // for more information of creating StorageTaskAssignmentResource, please refer to the document of StorageTaskAssignmentResource
            string subscriptionId = "1f31ba14-ce16-4281-b9b4-3e78da6e1616";
            string resourceGroupName = "res4228";
            string accountName = "sto4445";
            string storageTaskAssignmentName = "myassignment1";
            ResourceIdentifier storageTaskAssignmentResourceId = StorageTaskAssignmentResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, storageTaskAssignmentName);
            StorageTaskAssignmentResource storageTaskAssignment = client.GetStorageTaskAssignmentResource(storageTaskAssignmentResourceId);

            // invoke the operation and iterate over the result
            await foreach (StorageTaskReportInstance item in storageTaskAssignment.GetStorageTaskAssignmentInstancesReportsAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
