// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Storage.Models;

namespace Azure.ResourceManager.Storage.Samples
{
    public partial class Sample_StorageAccountLocalUserResource
    {
        // GetLocalUser
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetLocalUser()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/LocalUserGet.json
            // this example is just showing the usage of "LocalUsers_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageAccountLocalUserResource created on azure
            // for more information of creating StorageAccountLocalUserResource, please refer to the document of StorageAccountLocalUserResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res6977";
            string accountName = "sto2527";
            string username = "user1";
            ResourceIdentifier storageAccountLocalUserResourceId = StorageAccountLocalUserResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, username);
            StorageAccountLocalUserResource storageAccountLocalUser = client.GetStorageAccountLocalUserResource(storageAccountLocalUserResourceId);

            // invoke the operation
            StorageAccountLocalUserResource result = await storageAccountLocalUser.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StorageAccountLocalUserData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // CreateLocalUser
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateLocalUser()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/LocalUserCreate.json
            // this example is just showing the usage of "LocalUsers_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageAccountLocalUserResource created on azure
            // for more information of creating StorageAccountLocalUserResource, please refer to the document of StorageAccountLocalUserResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res6977";
            string accountName = "sto2527";
            string username = "user1";
            ResourceIdentifier storageAccountLocalUserResourceId = StorageAccountLocalUserResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, username);
            StorageAccountLocalUserResource storageAccountLocalUser = client.GetStorageAccountLocalUserResource(storageAccountLocalUserResourceId);

            // invoke the operation
            StorageAccountLocalUserData data = new StorageAccountLocalUserData()
            {
                PermissionScopes =
{
new StoragePermissionScope("rwd","file","share1"),new StoragePermissionScope("rw","file","share2")
},
                HomeDirectory = "homedirectory",
                SshAuthorizedKeys =
{
new StorageSshPublicKey()
{
Description = "key name",
Key = "ssh-rsa keykeykeykeykey=",
}
},
                HasSshPassword = true,
                GroupId = 2000,
                IsAclAuthorizationAllowed = true,
            };
            ArmOperation<StorageAccountLocalUserResource> lro = await storageAccountLocalUser.UpdateAsync(WaitUntil.Completed, data);
            StorageAccountLocalUserResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StorageAccountLocalUserData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // CreateNFSv3EnabledLocalUser
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateNFSv3EnabledLocalUser()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/LocalUserCreateNFSv3Enabled.json
            // this example is just showing the usage of "LocalUsers_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageAccountLocalUserResource created on azure
            // for more information of creating StorageAccountLocalUserResource, please refer to the document of StorageAccountLocalUserResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res6977";
            string accountName = "sto2527";
            string username = "user1";
            ResourceIdentifier storageAccountLocalUserResourceId = StorageAccountLocalUserResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, username);
            StorageAccountLocalUserResource storageAccountLocalUser = client.GetStorageAccountLocalUserResource(storageAccountLocalUserResourceId);

            // invoke the operation
            StorageAccountLocalUserData data = new StorageAccountLocalUserData()
            {
                ExtendedGroups =
{
1001,1005,2005
},
                IsNfsV3Enabled = true,
            };
            ArmOperation<StorageAccountLocalUserResource> lro = await storageAccountLocalUser.UpdateAsync(WaitUntil.Completed, data);
            StorageAccountLocalUserResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StorageAccountLocalUserData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // UpdateLocalUser
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateLocalUser()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/LocalUserUpdate.json
            // this example is just showing the usage of "LocalUsers_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageAccountLocalUserResource created on azure
            // for more information of creating StorageAccountLocalUserResource, please refer to the document of StorageAccountLocalUserResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res6977";
            string accountName = "sto2527";
            string username = "user1";
            ResourceIdentifier storageAccountLocalUserResourceId = StorageAccountLocalUserResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, username);
            StorageAccountLocalUserResource storageAccountLocalUser = client.GetStorageAccountLocalUserResource(storageAccountLocalUserResourceId);

            // invoke the operation
            StorageAccountLocalUserData data = new StorageAccountLocalUserData()
            {
                HomeDirectory = "homedirectory2",
                HasSharedKey = false,
                HasSshKey = false,
                HasSshPassword = false,
                GroupId = 3000,
                IsAclAuthorizationAllowed = false,
                ExtendedGroups =
{
1001,1005,2005
},
                IsNfsV3Enabled = true,
            };
            ArmOperation<StorageAccountLocalUserResource> lro = await storageAccountLocalUser.UpdateAsync(WaitUntil.Completed, data);
            StorageAccountLocalUserResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            StorageAccountLocalUserData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // DeleteLocalUser
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteLocalUser()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/LocalUserDelete.json
            // this example is just showing the usage of "LocalUsers_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageAccountLocalUserResource created on azure
            // for more information of creating StorageAccountLocalUserResource, please refer to the document of StorageAccountLocalUserResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res6977";
            string accountName = "sto2527";
            string username = "user1";
            ResourceIdentifier storageAccountLocalUserResourceId = StorageAccountLocalUserResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, username);
            StorageAccountLocalUserResource storageAccountLocalUser = client.GetStorageAccountLocalUserResource(storageAccountLocalUserResourceId);

            // invoke the operation
            await storageAccountLocalUser.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // ListLocalUserKeys
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetKeys_ListLocalUserKeys()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/LocalUserListKeys.json
            // this example is just showing the usage of "LocalUsers_ListKeys" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageAccountLocalUserResource created on azure
            // for more information of creating StorageAccountLocalUserResource, please refer to the document of StorageAccountLocalUserResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res6977";
            string accountName = "sto2527";
            string username = "user1";
            ResourceIdentifier storageAccountLocalUserResourceId = StorageAccountLocalUserResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, username);
            StorageAccountLocalUserResource storageAccountLocalUser = client.GetStorageAccountLocalUserResource(storageAccountLocalUserResourceId);

            // invoke the operation
            LocalUserKeys result = await storageAccountLocalUser.GetKeysAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // RegenerateLocalUserPassword
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task RegeneratePassword_RegenerateLocalUserPassword()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/LocalUserRegeneratePassword.json
            // this example is just showing the usage of "LocalUsers_RegeneratePassword" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageAccountLocalUserResource created on azure
            // for more information of creating StorageAccountLocalUserResource, please refer to the document of StorageAccountLocalUserResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res6977";
            string accountName = "sto2527";
            string username = "user1";
            ResourceIdentifier storageAccountLocalUserResourceId = StorageAccountLocalUserResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, username);
            StorageAccountLocalUserResource storageAccountLocalUser = client.GetStorageAccountLocalUserResource(storageAccountLocalUserResourceId);

            // invoke the operation
            LocalUserRegeneratePasswordResult result = await storageAccountLocalUser.RegeneratePasswordAsync();

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
