// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Storage.Models;

namespace Azure.ResourceManager.Storage.Samples
{
    public partial class Sample_ObjectReplicationPolicyCollection
    {
        // StorageAccountListObjectReplicationPolicies
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_StorageAccountListObjectReplicationPolicies()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/StorageAccountListObjectReplicationPolicies.json
            // this example is just showing the usage of "ObjectReplicationPolicies_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageAccountResource created on azure
            // for more information of creating StorageAccountResource, please refer to the document of StorageAccountResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res6977";
            string accountName = "sto2527";
            ResourceIdentifier storageAccountResourceId = StorageAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            StorageAccountResource storageAccount = client.GetStorageAccountResource(storageAccountResourceId);

            // get the collection of this ObjectReplicationPolicyResource
            ObjectReplicationPolicyCollection collection = storageAccount.GetObjectReplicationPolicies();

            // invoke the operation and iterate over the result
            await foreach (ObjectReplicationPolicyResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ObjectReplicationPolicyData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // StorageAccountGetObjectReplicationPolicies
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_StorageAccountGetObjectReplicationPolicies()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/StorageAccountGetObjectReplicationPolicy.json
            // this example is just showing the usage of "ObjectReplicationPolicies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageAccountResource created on azure
            // for more information of creating StorageAccountResource, please refer to the document of StorageAccountResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res6977";
            string accountName = "sto2527";
            ResourceIdentifier storageAccountResourceId = StorageAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            StorageAccountResource storageAccount = client.GetStorageAccountResource(storageAccountResourceId);

            // get the collection of this ObjectReplicationPolicyResource
            ObjectReplicationPolicyCollection collection = storageAccount.GetObjectReplicationPolicies();

            // invoke the operation
            string objectReplicationPolicyId = "{objectReplicationPolicy-Id}";
            ObjectReplicationPolicyResource result = await collection.GetAsync(objectReplicationPolicyId);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ObjectReplicationPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // StorageAccountGetObjectReplicationPolicies
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_StorageAccountGetObjectReplicationPolicies()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/StorageAccountGetObjectReplicationPolicy.json
            // this example is just showing the usage of "ObjectReplicationPolicies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageAccountResource created on azure
            // for more information of creating StorageAccountResource, please refer to the document of StorageAccountResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res6977";
            string accountName = "sto2527";
            ResourceIdentifier storageAccountResourceId = StorageAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            StorageAccountResource storageAccount = client.GetStorageAccountResource(storageAccountResourceId);

            // get the collection of this ObjectReplicationPolicyResource
            ObjectReplicationPolicyCollection collection = storageAccount.GetObjectReplicationPolicies();

            // invoke the operation
            string objectReplicationPolicyId = "{objectReplicationPolicy-Id}";
            bool result = await collection.ExistsAsync(objectReplicationPolicyId);

            Console.WriteLine($"Succeeded: {result}");
        }

        // StorageAccountGetObjectReplicationPolicies
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_StorageAccountGetObjectReplicationPolicies()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/StorageAccountGetObjectReplicationPolicy.json
            // this example is just showing the usage of "ObjectReplicationPolicies_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageAccountResource created on azure
            // for more information of creating StorageAccountResource, please refer to the document of StorageAccountResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res6977";
            string accountName = "sto2527";
            ResourceIdentifier storageAccountResourceId = StorageAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            StorageAccountResource storageAccount = client.GetStorageAccountResource(storageAccountResourceId);

            // get the collection of this ObjectReplicationPolicyResource
            ObjectReplicationPolicyCollection collection = storageAccount.GetObjectReplicationPolicies();

            // invoke the operation
            string objectReplicationPolicyId = "{objectReplicationPolicy-Id}";
            NullableResponse<ObjectReplicationPolicyResource> response = await collection.GetIfExistsAsync(objectReplicationPolicyId);
            ObjectReplicationPolicyResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ObjectReplicationPolicyData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // StorageAccountCreateObjectReplicationPolicyOnDestination
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_StorageAccountCreateObjectReplicationPolicyOnDestination()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/StorageAccountCreateObjectReplicationPolicyOnDestination.json
            // this example is just showing the usage of "ObjectReplicationPolicies_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageAccountResource created on azure
            // for more information of creating StorageAccountResource, please refer to the document of StorageAccountResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res7687";
            string accountName = "dst112";
            ResourceIdentifier storageAccountResourceId = StorageAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            StorageAccountResource storageAccount = client.GetStorageAccountResource(storageAccountResourceId);

            // get the collection of this ObjectReplicationPolicyResource
            ObjectReplicationPolicyCollection collection = storageAccount.GetObjectReplicationPolicies();

            // invoke the operation
            string objectReplicationPolicyId = "default";
            ObjectReplicationPolicyData data = new ObjectReplicationPolicyData()
            {
                SourceAccount = "src1122",
                DestinationAccount = "dst112",
                Rules =
{
new ObjectReplicationPolicyRule("scont139","dcont139")
{
Filters = new ObjectReplicationPolicyFilter()
{
PrefixMatch =
{
"blobA","blobB"
},
},
}
},
            };
            ArmOperation<ObjectReplicationPolicyResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, objectReplicationPolicyId, data);
            ObjectReplicationPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ObjectReplicationPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // StorageAccountCreateObjectReplicationPolicyOnSource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_StorageAccountCreateObjectReplicationPolicyOnSource()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/StorageAccountCreateObjectReplicationPolicyOnSource.json
            // this example is just showing the usage of "ObjectReplicationPolicies_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageAccountResource created on azure
            // for more information of creating StorageAccountResource, please refer to the document of StorageAccountResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res7687";
            string accountName = "src1122";
            ResourceIdentifier storageAccountResourceId = StorageAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            StorageAccountResource storageAccount = client.GetStorageAccountResource(storageAccountResourceId);

            // get the collection of this ObjectReplicationPolicyResource
            ObjectReplicationPolicyCollection collection = storageAccount.GetObjectReplicationPolicies();

            // invoke the operation
            string objectReplicationPolicyId = "2a20bb73-5717-4635-985a-5d4cf777438f";
            ObjectReplicationPolicyData data = new ObjectReplicationPolicyData()
            {
                SourceAccount = "src1122",
                DestinationAccount = "dst112",
                Rules =
{
new ObjectReplicationPolicyRule("scont139","dcont139")
{
RuleId = "d5d18a48-8801-4554-aeaa-74faf65f5ef9",
Filters = new ObjectReplicationPolicyFilter()
{
PrefixMatch =
{
"blobA","blobB"
},
MinCreationTime = "2020-02-19T16:05:00Z",
},
}
},
            };
            ArmOperation<ObjectReplicationPolicyResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, objectReplicationPolicyId, data);
            ObjectReplicationPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ObjectReplicationPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // StorageAccountUpdateObjectReplicationPolicyOnDestination
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_StorageAccountUpdateObjectReplicationPolicyOnDestination()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/StorageAccountUpdateObjectReplicationPolicyOnDestination.json
            // this example is just showing the usage of "ObjectReplicationPolicies_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageAccountResource created on azure
            // for more information of creating StorageAccountResource, please refer to the document of StorageAccountResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res7687";
            string accountName = "dst112";
            ResourceIdentifier storageAccountResourceId = StorageAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            StorageAccountResource storageAccount = client.GetStorageAccountResource(storageAccountResourceId);

            // get the collection of this ObjectReplicationPolicyResource
            ObjectReplicationPolicyCollection collection = storageAccount.GetObjectReplicationPolicies();

            // invoke the operation
            string objectReplicationPolicyId = "2a20bb73-5717-4635-985a-5d4cf777438f";
            ObjectReplicationPolicyData data = new ObjectReplicationPolicyData()
            {
                SourceAccount = "src1122",
                DestinationAccount = "dst112",
                Rules =
{
new ObjectReplicationPolicyRule("scont139","dcont139")
{
RuleId = "d5d18a48-8801-4554-aeaa-74faf65f5ef9",
Filters = new ObjectReplicationPolicyFilter()
{
PrefixMatch =
{
"blobA","blobB"
},
},
},new ObjectReplicationPolicyRule("scont179","dcont179")
},
            };
            ArmOperation<ObjectReplicationPolicyResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, objectReplicationPolicyId, data);
            ObjectReplicationPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ObjectReplicationPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // StorageAccountUpdateObjectReplicationPolicyOnSource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_StorageAccountUpdateObjectReplicationPolicyOnSource()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/StorageAccountUpdateObjectReplicationPolicyOnSource.json
            // this example is just showing the usage of "ObjectReplicationPolicies_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this StorageAccountResource created on azure
            // for more information of creating StorageAccountResource, please refer to the document of StorageAccountResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res7687";
            string accountName = "src1122";
            ResourceIdentifier storageAccountResourceId = StorageAccountResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            StorageAccountResource storageAccount = client.GetStorageAccountResource(storageAccountResourceId);

            // get the collection of this ObjectReplicationPolicyResource
            ObjectReplicationPolicyCollection collection = storageAccount.GetObjectReplicationPolicies();

            // invoke the operation
            string objectReplicationPolicyId = "2a20bb73-5717-4635-985a-5d4cf777438f";
            ObjectReplicationPolicyData data = new ObjectReplicationPolicyData()
            {
                SourceAccount = "src1122",
                DestinationAccount = "dst112",
                Rules =
{
new ObjectReplicationPolicyRule("scont139","dcont139")
{
RuleId = "d5d18a48-8801-4554-aeaa-74faf65f5ef9",
Filters = new ObjectReplicationPolicyFilter()
{
PrefixMatch =
{
"blobA","blobB"
},
},
},new ObjectReplicationPolicyRule("scont179","dcont179")
{
RuleId = "cfbb4bc2-8b60-429f-b05a-d1e0942b33b2",
}
},
            };
            ArmOperation<ObjectReplicationPolicyResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, objectReplicationPolicyId, data);
            ObjectReplicationPolicyResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ObjectReplicationPolicyData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
