// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Storage.Models;

namespace Azure.ResourceManager.Storage.Samples
{
    public partial class Sample_EncryptionScopeResource
    {
        // StorageAccountPatchEncryptionScope
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_StorageAccountPatchEncryptionScope()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/StorageAccountPatchEncryptionScope.json
            // this example is just showing the usage of "EncryptionScopes_Patch" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EncryptionScopeResource created on azure
            // for more information of creating EncryptionScopeResource, please refer to the document of EncryptionScopeResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "resource-group-name";
            string accountName = "accountname";
            string encryptionScopeName = "{encryption-scope-name}";
            ResourceIdentifier encryptionScopeResourceId = EncryptionScopeResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, encryptionScopeName);
            EncryptionScopeResource encryptionScope = client.GetEncryptionScopeResource(encryptionScopeResourceId);

            // invoke the operation
            EncryptionScopeData data = new EncryptionScopeData()
            {
                Source = EncryptionScopeSource.KeyVault,
                KeyVaultProperties = new EncryptionScopeKeyVaultProperties()
                {
                    KeyUri = new Uri("https://testvault.vault.core.windows.net/keys/key1/863425f1358359c"),
                },
            };
            EncryptionScopeResource result = await encryptionScope.UpdateAsync(data);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            EncryptionScopeData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // StorageAccountGetEncryptionScope
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_StorageAccountGetEncryptionScope()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/StorageAccountGetEncryptionScope.json
            // this example is just showing the usage of "EncryptionScopes_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this EncryptionScopeResource created on azure
            // for more information of creating EncryptionScopeResource, please refer to the document of EncryptionScopeResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "resource-group-name";
            string accountName = "accountname";
            string encryptionScopeName = "{encryption-scope-name}";
            ResourceIdentifier encryptionScopeResourceId = EncryptionScopeResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, encryptionScopeName);
            EncryptionScopeResource encryptionScope = client.GetEncryptionScopeResource(encryptionScopeResourceId);

            // invoke the operation
            EncryptionScopeResource result = await encryptionScope.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            EncryptionScopeData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
