// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Storage.Models;

namespace Azure.ResourceManager.Storage.Samples
{
    public partial class Sample_BlobContainerResource
    {
        // UpdateContainers
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateContainers()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/BlobContainersPatch.json
            // this example is just showing the usage of "BlobContainers_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlobContainerResource created on azure
            // for more information of creating BlobContainerResource, please refer to the document of BlobContainerResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res3376";
            string accountName = "sto328";
            string containerName = "container6185";
            ResourceIdentifier blobContainerResourceId = BlobContainerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, containerName);
            BlobContainerResource blobContainer = client.GetBlobContainerResource(blobContainerResourceId);

            // invoke the operation
            BlobContainerData data = new BlobContainerData()
            {
                PublicAccess = StoragePublicAccessType.Container,
                Metadata =
{
["metadata"] = "true",
},
            };
            BlobContainerResource result = await blobContainer.UpdateAsync(data);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BlobContainerData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // GetBlobContainersGetWithAllowProtectedAppendWritesAll
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetBlobContainersGetWithAllowProtectedAppendWritesAll()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/BlobContainersGetWithAllowProtectedAppendWritesAll.json
            // this example is just showing the usage of "BlobContainers_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlobContainerResource created on azure
            // for more information of creating BlobContainerResource, please refer to the document of BlobContainerResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res9871";
            string accountName = "sto6217";
            string containerName = "container1634";
            ResourceIdentifier blobContainerResourceId = BlobContainerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, containerName);
            BlobContainerResource blobContainer = client.GetBlobContainerResource(blobContainerResourceId);

            // invoke the operation
            BlobContainerResource result = await blobContainer.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BlobContainerData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // GetContainers
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetContainers()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/BlobContainersGet.json
            // this example is just showing the usage of "BlobContainers_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlobContainerResource created on azure
            // for more information of creating BlobContainerResource, please refer to the document of BlobContainerResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res9871";
            string accountName = "sto6217";
            string containerName = "container1634";
            ResourceIdentifier blobContainerResourceId = BlobContainerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, containerName);
            BlobContainerResource blobContainer = client.GetBlobContainerResource(blobContainerResourceId);

            // invoke the operation
            BlobContainerResource result = await blobContainer.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BlobContainerData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // DeleteContainers
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteContainers()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/BlobContainersDelete.json
            // this example is just showing the usage of "BlobContainers_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlobContainerResource created on azure
            // for more information of creating BlobContainerResource, please refer to the document of BlobContainerResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res4079";
            string accountName = "sto4506";
            string containerName = "container9689";
            ResourceIdentifier blobContainerResourceId = BlobContainerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, containerName);
            BlobContainerResource blobContainer = client.GetBlobContainerResource(blobContainerResourceId);

            // invoke the operation
            await blobContainer.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // SetLegalHoldContainers
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task SetLegalHold_SetLegalHoldContainers()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/BlobContainersSetLegalHold.json
            // this example is just showing the usage of "BlobContainers_SetLegalHold" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlobContainerResource created on azure
            // for more information of creating BlobContainerResource, please refer to the document of BlobContainerResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res4303";
            string accountName = "sto7280";
            string containerName = "container8723";
            ResourceIdentifier blobContainerResourceId = BlobContainerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, containerName);
            BlobContainerResource blobContainer = client.GetBlobContainerResource(blobContainerResourceId);

            // invoke the operation
            LegalHold legalHold = new LegalHold(new string[]
            {
"tag1","tag2","tag3"
            });
            LegalHold result = await blobContainer.SetLegalHoldAsync(legalHold);

            Console.WriteLine($"Succeeded: {result}");
        }

        // SetLegalHoldContainersWithAllowProtectedAppendWritesAll
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task SetLegalHold_SetLegalHoldContainersWithAllowProtectedAppendWritesAll()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/BlobContainersSetLegalHoldAllowProtectedAppendWritesAll.json
            // this example is just showing the usage of "BlobContainers_SetLegalHold" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlobContainerResource created on azure
            // for more information of creating BlobContainerResource, please refer to the document of BlobContainerResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res4303";
            string accountName = "sto7280";
            string containerName = "container8723";
            ResourceIdentifier blobContainerResourceId = BlobContainerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, containerName);
            BlobContainerResource blobContainer = client.GetBlobContainerResource(blobContainerResourceId);

            // invoke the operation
            LegalHold legalHold = new LegalHold(new string[]
            {
"tag1","tag2","tag3"
            })
            {
                AllowProtectedAppendWritesAll = true,
            };
            LegalHold result = await blobContainer.SetLegalHoldAsync(legalHold);

            Console.WriteLine($"Succeeded: {result}");
        }

        // ClearLegalHoldContainers
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task ClearLegalHold_ClearLegalHoldContainers()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/BlobContainersClearLegalHold.json
            // this example is just showing the usage of "BlobContainers_ClearLegalHold" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlobContainerResource created on azure
            // for more information of creating BlobContainerResource, please refer to the document of BlobContainerResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res4303";
            string accountName = "sto7280";
            string containerName = "container8723";
            ResourceIdentifier blobContainerResourceId = BlobContainerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, containerName);
            BlobContainerResource blobContainer = client.GetBlobContainerResource(blobContainerResourceId);

            // invoke the operation
            LegalHold legalHold = new LegalHold(new string[]
            {
"tag1","tag2","tag3"
            });
            LegalHold result = await blobContainer.ClearLegalHoldAsync(legalHold);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Acquire a lease on a container
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Lease_AcquireALeaseOnAContainer()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/BlobContainersLease_Acquire.json
            // this example is just showing the usage of "BlobContainers_Lease" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlobContainerResource created on azure
            // for more information of creating BlobContainerResource, please refer to the document of BlobContainerResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res3376";
            string accountName = "sto328";
            string containerName = "container6185";
            ResourceIdentifier blobContainerResourceId = BlobContainerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, containerName);
            BlobContainerResource blobContainer = client.GetBlobContainerResource(blobContainerResourceId);

            // invoke the operation
            LeaseContainerContent content = new LeaseContainerContent(LeaseContainerAction.Acquire)
            {
                LeaseId = null,
                BreakPeriod = null,
                LeaseDuration = -1,
                ProposedLeaseId = null,
            };
            LeaseContainerResponse result = await blobContainer.LeaseAsync(content: content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Break a lease on a container
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Lease_BreakALeaseOnAContainer()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/BlobContainersLease_Break.json
            // this example is just showing the usage of "BlobContainers_Lease" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlobContainerResource created on azure
            // for more information of creating BlobContainerResource, please refer to the document of BlobContainerResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res3376";
            string accountName = "sto328";
            string containerName = "container6185";
            ResourceIdentifier blobContainerResourceId = BlobContainerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, containerName);
            BlobContainerResource blobContainer = client.GetBlobContainerResource(blobContainerResourceId);

            // invoke the operation
            LeaseContainerContent content = new LeaseContainerContent(LeaseContainerAction.Break)
            {
                LeaseId = "8698f513-fa75-44a1-b8eb-30ba336af27d",
                BreakPeriod = null,
                LeaseDuration = null,
                ProposedLeaseId = null,
            };
            LeaseContainerResponse result = await blobContainer.LeaseAsync(content: content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // VersionLevelWormContainerMigration
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task EnableVersionLevelImmutability_VersionLevelWormContainerMigration()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/ObjectLevelWormContainerMigration.json
            // this example is just showing the usage of "BlobContainers_ObjectLevelWorm" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlobContainerResource created on azure
            // for more information of creating BlobContainerResource, please refer to the document of BlobContainerResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res1782";
            string accountName = "sto7069";
            string containerName = "container6397";
            ResourceIdentifier blobContainerResourceId = BlobContainerResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName, containerName);
            BlobContainerResource blobContainer = client.GetBlobContainerResource(blobContainerResourceId);

            // invoke the operation
            await blobContainer.EnableVersionLevelImmutabilityAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
