// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Storage.Models;

namespace Azure.ResourceManager.Storage.Samples
{
    public partial class Sample_BlobContainerCollection
    {
        // ListContainers
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListContainers()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/BlobContainersList.json
            // this example is just showing the usage of "BlobContainers_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlobServiceResource created on azure
            // for more information of creating BlobServiceResource, please refer to the document of BlobServiceResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res9290";
            string accountName = "sto1590";
            ResourceIdentifier blobServiceResourceId = BlobServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            BlobServiceResource blobService = client.GetBlobServiceResource(blobServiceResourceId);

            // get the collection of this BlobContainerResource
            BlobContainerCollection collection = blobService.GetBlobContainers();

            // invoke the operation and iterate over the result
            await foreach (BlobContainerResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BlobContainerData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // ListDeletedContainers
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListDeletedContainers()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/DeletedBlobContainersList.json
            // this example is just showing the usage of "BlobContainers_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlobServiceResource created on azure
            // for more information of creating BlobServiceResource, please refer to the document of BlobServiceResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res9290";
            string accountName = "sto1590";
            ResourceIdentifier blobServiceResourceId = BlobServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            BlobServiceResource blobService = client.GetBlobServiceResource(blobServiceResourceId);

            // get the collection of this BlobContainerResource
            BlobContainerCollection collection = blobService.GetBlobContainers();

            // invoke the operation and iterate over the result
            BlobContainerState? include = BlobContainerState.Deleted;
            await foreach (BlobContainerResource item in collection.GetAllAsync(include: include))
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BlobContainerData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // PutContainerWithDefaultEncryptionScope
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_PutContainerWithDefaultEncryptionScope()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/BlobContainersPutDefaultEncryptionScope.json
            // this example is just showing the usage of "BlobContainers_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlobServiceResource created on azure
            // for more information of creating BlobServiceResource, please refer to the document of BlobServiceResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res3376";
            string accountName = "sto328";
            ResourceIdentifier blobServiceResourceId = BlobServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            BlobServiceResource blobService = client.GetBlobServiceResource(blobServiceResourceId);

            // get the collection of this BlobContainerResource
            BlobContainerCollection collection = blobService.GetBlobContainers();

            // invoke the operation
            string containerName = "container6185";
            BlobContainerData data = new BlobContainerData()
            {
                DefaultEncryptionScope = "encryptionscope185",
                PreventEncryptionScopeOverride = true,
            };
            ArmOperation<BlobContainerResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, containerName, data);
            BlobContainerResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BlobContainerData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // PutContainerWithObjectLevelWorm
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_PutContainerWithObjectLevelWorm()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/BlobContainersPutObjectLevelWorm.json
            // this example is just showing the usage of "BlobContainers_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlobServiceResource created on azure
            // for more information of creating BlobServiceResource, please refer to the document of BlobServiceResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res3376";
            string accountName = "sto328";
            ResourceIdentifier blobServiceResourceId = BlobServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            BlobServiceResource blobService = client.GetBlobServiceResource(blobServiceResourceId);

            // get the collection of this BlobContainerResource
            BlobContainerCollection collection = blobService.GetBlobContainers();

            // invoke the operation
            string containerName = "container6185";
            BlobContainerData data = new BlobContainerData()
            {
                ImmutableStorageWithVersioning = new ImmutableStorageWithVersioning()
                {
                    IsEnabled = true,
                },
            };
            ArmOperation<BlobContainerResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, containerName, data);
            BlobContainerResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BlobContainerData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // PutContainers
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_PutContainers()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/BlobContainersPut.json
            // this example is just showing the usage of "BlobContainers_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlobServiceResource created on azure
            // for more information of creating BlobServiceResource, please refer to the document of BlobServiceResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res3376";
            string accountName = "sto328";
            ResourceIdentifier blobServiceResourceId = BlobServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            BlobServiceResource blobService = client.GetBlobServiceResource(blobServiceResourceId);

            // get the collection of this BlobContainerResource
            BlobContainerCollection collection = blobService.GetBlobContainers();

            // invoke the operation
            string containerName = "container6185";
            BlobContainerData data = new BlobContainerData();
            ArmOperation<BlobContainerResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, containerName, data);
            BlobContainerResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BlobContainerData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // GetBlobContainersGetWithAllowProtectedAppendWritesAll
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetBlobContainersGetWithAllowProtectedAppendWritesAll()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/BlobContainersGetWithAllowProtectedAppendWritesAll.json
            // this example is just showing the usage of "BlobContainers_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlobServiceResource created on azure
            // for more information of creating BlobServiceResource, please refer to the document of BlobServiceResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res9871";
            string accountName = "sto6217";
            ResourceIdentifier blobServiceResourceId = BlobServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            BlobServiceResource blobService = client.GetBlobServiceResource(blobServiceResourceId);

            // get the collection of this BlobContainerResource
            BlobContainerCollection collection = blobService.GetBlobContainers();

            // invoke the operation
            string containerName = "container1634";
            BlobContainerResource result = await collection.GetAsync(containerName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BlobContainerData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // GetBlobContainersGetWithAllowProtectedAppendWritesAll
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetBlobContainersGetWithAllowProtectedAppendWritesAll()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/BlobContainersGetWithAllowProtectedAppendWritesAll.json
            // this example is just showing the usage of "BlobContainers_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlobServiceResource created on azure
            // for more information of creating BlobServiceResource, please refer to the document of BlobServiceResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res9871";
            string accountName = "sto6217";
            ResourceIdentifier blobServiceResourceId = BlobServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            BlobServiceResource blobService = client.GetBlobServiceResource(blobServiceResourceId);

            // get the collection of this BlobContainerResource
            BlobContainerCollection collection = blobService.GetBlobContainers();

            // invoke the operation
            string containerName = "container1634";
            bool result = await collection.ExistsAsync(containerName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // GetBlobContainersGetWithAllowProtectedAppendWritesAll
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetBlobContainersGetWithAllowProtectedAppendWritesAll()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/BlobContainersGetWithAllowProtectedAppendWritesAll.json
            // this example is just showing the usage of "BlobContainers_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlobServiceResource created on azure
            // for more information of creating BlobServiceResource, please refer to the document of BlobServiceResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res9871";
            string accountName = "sto6217";
            ResourceIdentifier blobServiceResourceId = BlobServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            BlobServiceResource blobService = client.GetBlobServiceResource(blobServiceResourceId);

            // get the collection of this BlobContainerResource
            BlobContainerCollection collection = blobService.GetBlobContainers();

            // invoke the operation
            string containerName = "container1634";
            NullableResponse<BlobContainerResource> response = await collection.GetIfExistsAsync(containerName);
            BlobContainerResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BlobContainerData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // GetContainers
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetContainers()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/BlobContainersGet.json
            // this example is just showing the usage of "BlobContainers_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlobServiceResource created on azure
            // for more information of creating BlobServiceResource, please refer to the document of BlobServiceResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res9871";
            string accountName = "sto6217";
            ResourceIdentifier blobServiceResourceId = BlobServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            BlobServiceResource blobService = client.GetBlobServiceResource(blobServiceResourceId);

            // get the collection of this BlobContainerResource
            BlobContainerCollection collection = blobService.GetBlobContainers();

            // invoke the operation
            string containerName = "container1634";
            BlobContainerResource result = await collection.GetAsync(containerName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BlobContainerData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // GetContainers
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetContainers()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/BlobContainersGet.json
            // this example is just showing the usage of "BlobContainers_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlobServiceResource created on azure
            // for more information of creating BlobServiceResource, please refer to the document of BlobServiceResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res9871";
            string accountName = "sto6217";
            ResourceIdentifier blobServiceResourceId = BlobServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            BlobServiceResource blobService = client.GetBlobServiceResource(blobServiceResourceId);

            // get the collection of this BlobContainerResource
            BlobContainerCollection collection = blobService.GetBlobContainers();

            // invoke the operation
            string containerName = "container1634";
            bool result = await collection.ExistsAsync(containerName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // GetContainers
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetContainers()
        {
            // Generated from example definition: specification/storage/resource-manager/Microsoft.Storage/stable/2023-05-01/examples/BlobContainersGet.json
            // this example is just showing the usage of "BlobContainers_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlobServiceResource created on azure
            // for more information of creating BlobServiceResource, please refer to the document of BlobServiceResource
            string subscriptionId = "{subscription-id}";
            string resourceGroupName = "res9871";
            string accountName = "sto6217";
            ResourceIdentifier blobServiceResourceId = BlobServiceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, accountName);
            BlobServiceResource blobService = client.GetBlobServiceResource(blobServiceResourceId);

            // get the collection of this BlobContainerResource
            BlobContainerCollection collection = blobService.GetBlobContainers();

            // invoke the operation
            string containerName = "container1634";
            NullableResponse<BlobContainerResource> response = await collection.GetIfExistsAsync(containerName);
            BlobContainerResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BlobContainerData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
