// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.StandbyPool
{
    /// <summary>
    /// A class representing a collection of <see cref="StandbyVirtualMachineResource"/> and their operations.
    /// Each <see cref="StandbyVirtualMachineResource"/> in the collection will belong to the same instance of <see cref="StandbyVirtualMachinePoolResource"/>.
    /// To get a <see cref="StandbyVirtualMachineCollection"/> instance call the GetStandbyVirtualMachines method from an instance of <see cref="StandbyVirtualMachinePoolResource"/>.
    /// </summary>
    public partial class StandbyVirtualMachineCollection : ArmCollection, IEnumerable<StandbyVirtualMachineResource>, IAsyncEnumerable<StandbyVirtualMachineResource>
    {
        private readonly ClientDiagnostics _standbyVirtualMachineClientDiagnostics;
        private readonly StandbyVirtualMachinesRestOperations _standbyVirtualMachineRestClient;

        /// <summary> Initializes a new instance of the <see cref="StandbyVirtualMachineCollection"/> class for mocking. </summary>
        protected StandbyVirtualMachineCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="StandbyVirtualMachineCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal StandbyVirtualMachineCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _standbyVirtualMachineClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.StandbyPool", StandbyVirtualMachineResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(StandbyVirtualMachineResource.ResourceType, out string standbyVirtualMachineApiVersion);
            _standbyVirtualMachineRestClient = new StandbyVirtualMachinesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, standbyVirtualMachineApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != StandbyVirtualMachinePoolResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, StandbyVirtualMachinePoolResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Get a StandbyVirtualMachineResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StandbyPool/standbyVirtualMachinePools/{standbyVirtualMachinePoolName}/standbyVirtualMachines/{standbyVirtualMachineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StandbyVirtualMachineResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StandbyVirtualMachineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="standbyVirtualMachineName"> Name of the standby virtual machine. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="standbyVirtualMachineName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="standbyVirtualMachineName"/> is null. </exception>
        public virtual async Task<Response<StandbyVirtualMachineResource>> GetAsync(string standbyVirtualMachineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(standbyVirtualMachineName, nameof(standbyVirtualMachineName));

            using var scope = _standbyVirtualMachineClientDiagnostics.CreateScope("StandbyVirtualMachineCollection.Get");
            scope.Start();
            try
            {
                var response = await _standbyVirtualMachineRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, standbyVirtualMachineName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new StandbyVirtualMachineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a StandbyVirtualMachineResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StandbyPool/standbyVirtualMachinePools/{standbyVirtualMachinePoolName}/standbyVirtualMachines/{standbyVirtualMachineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StandbyVirtualMachineResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StandbyVirtualMachineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="standbyVirtualMachineName"> Name of the standby virtual machine. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="standbyVirtualMachineName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="standbyVirtualMachineName"/> is null. </exception>
        public virtual Response<StandbyVirtualMachineResource> Get(string standbyVirtualMachineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(standbyVirtualMachineName, nameof(standbyVirtualMachineName));

            using var scope = _standbyVirtualMachineClientDiagnostics.CreateScope("StandbyVirtualMachineCollection.Get");
            scope.Start();
            try
            {
                var response = _standbyVirtualMachineRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, standbyVirtualMachineName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new StandbyVirtualMachineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List StandbyVirtualMachineResource resources by StandbyVirtualMachinePoolResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StandbyPool/standbyVirtualMachinePools/{standbyVirtualMachinePoolName}/standbyVirtualMachines</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StandbyVirtualMachineResource_ListByStandbyVirtualMachinePoolResource</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StandbyVirtualMachineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="StandbyVirtualMachineResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<StandbyVirtualMachineResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _standbyVirtualMachineRestClient.CreateListByStandbyVirtualMachinePoolResourceRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _standbyVirtualMachineRestClient.CreateListByStandbyVirtualMachinePoolResourceNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new StandbyVirtualMachineResource(Client, StandbyVirtualMachineData.DeserializeStandbyVirtualMachineData(e)), _standbyVirtualMachineClientDiagnostics, Pipeline, "StandbyVirtualMachineCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List StandbyVirtualMachineResource resources by StandbyVirtualMachinePoolResource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StandbyPool/standbyVirtualMachinePools/{standbyVirtualMachinePoolName}/standbyVirtualMachines</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StandbyVirtualMachineResource_ListByStandbyVirtualMachinePoolResource</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StandbyVirtualMachineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="StandbyVirtualMachineResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<StandbyVirtualMachineResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _standbyVirtualMachineRestClient.CreateListByStandbyVirtualMachinePoolResourceRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _standbyVirtualMachineRestClient.CreateListByStandbyVirtualMachinePoolResourceNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new StandbyVirtualMachineResource(Client, StandbyVirtualMachineData.DeserializeStandbyVirtualMachineData(e)), _standbyVirtualMachineClientDiagnostics, Pipeline, "StandbyVirtualMachineCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StandbyPool/standbyVirtualMachinePools/{standbyVirtualMachinePoolName}/standbyVirtualMachines/{standbyVirtualMachineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StandbyVirtualMachineResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StandbyVirtualMachineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="standbyVirtualMachineName"> Name of the standby virtual machine. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="standbyVirtualMachineName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="standbyVirtualMachineName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string standbyVirtualMachineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(standbyVirtualMachineName, nameof(standbyVirtualMachineName));

            using var scope = _standbyVirtualMachineClientDiagnostics.CreateScope("StandbyVirtualMachineCollection.Exists");
            scope.Start();
            try
            {
                var response = await _standbyVirtualMachineRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, standbyVirtualMachineName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StandbyPool/standbyVirtualMachinePools/{standbyVirtualMachinePoolName}/standbyVirtualMachines/{standbyVirtualMachineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StandbyVirtualMachineResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StandbyVirtualMachineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="standbyVirtualMachineName"> Name of the standby virtual machine. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="standbyVirtualMachineName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="standbyVirtualMachineName"/> is null. </exception>
        public virtual Response<bool> Exists(string standbyVirtualMachineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(standbyVirtualMachineName, nameof(standbyVirtualMachineName));

            using var scope = _standbyVirtualMachineClientDiagnostics.CreateScope("StandbyVirtualMachineCollection.Exists");
            scope.Start();
            try
            {
                var response = _standbyVirtualMachineRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, standbyVirtualMachineName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StandbyPool/standbyVirtualMachinePools/{standbyVirtualMachinePoolName}/standbyVirtualMachines/{standbyVirtualMachineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StandbyVirtualMachineResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StandbyVirtualMachineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="standbyVirtualMachineName"> Name of the standby virtual machine. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="standbyVirtualMachineName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="standbyVirtualMachineName"/> is null. </exception>
        public virtual async Task<NullableResponse<StandbyVirtualMachineResource>> GetIfExistsAsync(string standbyVirtualMachineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(standbyVirtualMachineName, nameof(standbyVirtualMachineName));

            using var scope = _standbyVirtualMachineClientDiagnostics.CreateScope("StandbyVirtualMachineCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _standbyVirtualMachineRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, standbyVirtualMachineName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<StandbyVirtualMachineResource>(response.GetRawResponse());
                return Response.FromValue(new StandbyVirtualMachineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StandbyPool/standbyVirtualMachinePools/{standbyVirtualMachinePoolName}/standbyVirtualMachines/{standbyVirtualMachineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>StandbyVirtualMachineResource_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-03-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="StandbyVirtualMachineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="standbyVirtualMachineName"> Name of the standby virtual machine. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="standbyVirtualMachineName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="standbyVirtualMachineName"/> is null. </exception>
        public virtual NullableResponse<StandbyVirtualMachineResource> GetIfExists(string standbyVirtualMachineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(standbyVirtualMachineName, nameof(standbyVirtualMachineName));

            using var scope = _standbyVirtualMachineClientDiagnostics.CreateScope("StandbyVirtualMachineCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _standbyVirtualMachineRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, standbyVirtualMachineName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<StandbyVirtualMachineResource>(response.GetRawResponse());
                return Response.FromValue(new StandbyVirtualMachineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<StandbyVirtualMachineResource> IEnumerable<StandbyVirtualMachineResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<StandbyVirtualMachineResource> IAsyncEnumerable<StandbyVirtualMachineResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
