// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.StandbyPool.Models
{
    /// <summary> Details of the StandbyVirtualMachine. </summary>
    public partial class StandbyVirtualMachineProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StandbyVirtualMachineProperties"/>. </summary>
        /// <param name="virtualMachineResourceId"> Resource id of the virtual machine. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="virtualMachineResourceId"/> is null. </exception>
        internal StandbyVirtualMachineProperties(ResourceIdentifier virtualMachineResourceId)
        {
            Argument.AssertNotNull(virtualMachineResourceId, nameof(virtualMachineResourceId));

            VirtualMachineResourceId = virtualMachineResourceId;
        }

        /// <summary> Initializes a new instance of <see cref="StandbyVirtualMachineProperties"/>. </summary>
        /// <param name="virtualMachineResourceId"> Resource id of the virtual machine. </param>
        /// <param name="provisioningState"> The status of the last operation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StandbyVirtualMachineProperties(ResourceIdentifier virtualMachineResourceId, StandbyProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            VirtualMachineResourceId = virtualMachineResourceId;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="StandbyVirtualMachineProperties"/> for deserialization. </summary>
        internal StandbyVirtualMachineProperties()
        {
        }

        /// <summary> Resource id of the virtual machine. </summary>
        public ResourceIdentifier VirtualMachineResourceId { get; }
        /// <summary> The status of the last operation. </summary>
        public StandbyProvisioningState? ProvisioningState { get; }
    }
}
