// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.StandbyPool.Models
{
    public partial class StandbyVirtualMachinePoolUpdateProperties : IUtf8JsonSerializable, IJsonModel<StandbyVirtualMachinePoolUpdateProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<StandbyVirtualMachinePoolUpdateProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<StandbyVirtualMachinePoolUpdateProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StandbyVirtualMachinePoolUpdateProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StandbyVirtualMachinePoolUpdateProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ElasticityProfile))
            {
                writer.WritePropertyName("elasticityProfile"u8);
                writer.WriteObjectValue(ElasticityProfile, options);
            }
            if (Optional.IsDefined(VirtualMachineState))
            {
                writer.WritePropertyName("virtualMachineState"u8);
                writer.WriteStringValue(VirtualMachineState.Value.ToString());
            }
            if (Optional.IsDefined(AttachedVirtualMachineScaleSetId))
            {
                writer.WritePropertyName("attachedVirtualMachineScaleSetId"u8);
                writer.WriteStringValue(AttachedVirtualMachineScaleSetId);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        StandbyVirtualMachinePoolUpdateProperties IJsonModel<StandbyVirtualMachinePoolUpdateProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StandbyVirtualMachinePoolUpdateProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StandbyVirtualMachinePoolUpdateProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeStandbyVirtualMachinePoolUpdateProperties(document.RootElement, options);
        }

        internal static StandbyVirtualMachinePoolUpdateProperties DeserializeStandbyVirtualMachinePoolUpdateProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            StandbyVirtualMachinePoolElasticityProfile elasticityProfile = default;
            StandbyVirtualMachineState? virtualMachineState = default;
            ResourceIdentifier attachedVirtualMachineScaleSetId = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("elasticityProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    elasticityProfile = StandbyVirtualMachinePoolElasticityProfile.DeserializeStandbyVirtualMachinePoolElasticityProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("virtualMachineState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    virtualMachineState = new StandbyVirtualMachineState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("attachedVirtualMachineScaleSetId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    attachedVirtualMachineScaleSetId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new StandbyVirtualMachinePoolUpdateProperties(elasticityProfile, virtualMachineState, attachedVirtualMachineScaleSetId, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<StandbyVirtualMachinePoolUpdateProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StandbyVirtualMachinePoolUpdateProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(StandbyVirtualMachinePoolUpdateProperties)} does not support writing '{options.Format}' format.");
            }
        }

        StandbyVirtualMachinePoolUpdateProperties IPersistableModel<StandbyVirtualMachinePoolUpdateProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StandbyVirtualMachinePoolUpdateProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeStandbyVirtualMachinePoolUpdateProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(StandbyVirtualMachinePoolUpdateProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<StandbyVirtualMachinePoolUpdateProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
