// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.StandbyPool.Models
{
    /// <summary> Details of the StandbyVirtualMachinePool. </summary>
    public partial class StandbyVirtualMachinePoolProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StandbyVirtualMachinePoolProperties"/>. </summary>
        /// <param name="virtualMachineState"> Specifies the desired state of virtual machines in the pool. </param>
        public StandbyVirtualMachinePoolProperties(StandbyVirtualMachineState virtualMachineState)
        {
            VirtualMachineState = virtualMachineState;
        }

        /// <summary> Initializes a new instance of <see cref="StandbyVirtualMachinePoolProperties"/>. </summary>
        /// <param name="elasticityProfile"> Specifies the elasticity profile of the standby virtual machine pools. </param>
        /// <param name="virtualMachineState"> Specifies the desired state of virtual machines in the pool. </param>
        /// <param name="attachedVirtualMachineScaleSetId"> Specifies the fully qualified resource ID of a virtual machine scale set the pool is attached to. </param>
        /// <param name="provisioningState"> The status of the last operation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StandbyVirtualMachinePoolProperties(StandbyVirtualMachinePoolElasticityProfile elasticityProfile, StandbyVirtualMachineState virtualMachineState, ResourceIdentifier attachedVirtualMachineScaleSetId, StandbyProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ElasticityProfile = elasticityProfile;
            VirtualMachineState = virtualMachineState;
            AttachedVirtualMachineScaleSetId = attachedVirtualMachineScaleSetId;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="StandbyVirtualMachinePoolProperties"/> for deserialization. </summary>
        internal StandbyVirtualMachinePoolProperties()
        {
        }

        /// <summary> Specifies the elasticity profile of the standby virtual machine pools. </summary>
        public StandbyVirtualMachinePoolElasticityProfile ElasticityProfile { get; set; }
        /// <summary> Specifies the desired state of virtual machines in the pool. </summary>
        public StandbyVirtualMachineState VirtualMachineState { get; set; }
        /// <summary> Specifies the fully qualified resource ID of a virtual machine scale set the pool is attached to. </summary>
        public ResourceIdentifier AttachedVirtualMachineScaleSetId { get; set; }
        /// <summary> The status of the last operation. </summary>
        public StandbyProvisioningState? ProvisioningState { get; }
    }
}
