// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.StandbyPool.Models
{
    /// <summary> Details of the ContainerGroupProperties. </summary>
    public partial class StandbyContainerGroupProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StandbyContainerGroupProperties"/>. </summary>
        /// <param name="containerGroupProfile"> Specifies container group profile of standby container groups. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="containerGroupProfile"/> is null. </exception>
        public StandbyContainerGroupProperties(StandbyContainerGroupProfile containerGroupProfile)
        {
            Argument.AssertNotNull(containerGroupProfile, nameof(containerGroupProfile));

            ContainerGroupProfile = containerGroupProfile;
            SubnetIds = new ChangeTrackingList<WritableSubResource>();
        }

        /// <summary> Initializes a new instance of <see cref="StandbyContainerGroupProperties"/>. </summary>
        /// <param name="containerGroupProfile"> Specifies container group profile of standby container groups. </param>
        /// <param name="subnetIds"> Specifies subnet Ids for container group. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StandbyContainerGroupProperties(StandbyContainerGroupProfile containerGroupProfile, IList<WritableSubResource> subnetIds, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ContainerGroupProfile = containerGroupProfile;
            SubnetIds = subnetIds;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="StandbyContainerGroupProperties"/> for deserialization. </summary>
        internal StandbyContainerGroupProperties()
        {
        }

        /// <summary> Specifies container group profile of standby container groups. </summary>
        public StandbyContainerGroupProfile ContainerGroupProfile { get; set; }
        /// <summary> Specifies subnet Ids for container group. </summary>
        public IList<WritableSubResource> SubnetIds { get; }
    }
}
