// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.StandbyPool.Models
{
    public partial class StandbyContainerGroupPoolUpdateProperties : IUtf8JsonSerializable, IJsonModel<StandbyContainerGroupPoolUpdateProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<StandbyContainerGroupPoolUpdateProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<StandbyContainerGroupPoolUpdateProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StandbyContainerGroupPoolUpdateProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StandbyContainerGroupPoolUpdateProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ElasticityProfile))
            {
                writer.WritePropertyName("elasticityProfile"u8);
                writer.WriteObjectValue(ElasticityProfile, options);
            }
            if (Optional.IsDefined(ContainerGroupProperties))
            {
                writer.WritePropertyName("containerGroupProperties"u8);
                writer.WriteObjectValue(ContainerGroupProperties, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        StandbyContainerGroupPoolUpdateProperties IJsonModel<StandbyContainerGroupPoolUpdateProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StandbyContainerGroupPoolUpdateProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StandbyContainerGroupPoolUpdateProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeStandbyContainerGroupPoolUpdateProperties(document.RootElement, options);
        }

        internal static StandbyContainerGroupPoolUpdateProperties DeserializeStandbyContainerGroupPoolUpdateProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            StandbyContainerGroupPoolElasticityProfile elasticityProfile = default;
            StandbyContainerGroupProperties containerGroupProperties = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("elasticityProfile"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    elasticityProfile = StandbyContainerGroupPoolElasticityProfile.DeserializeStandbyContainerGroupPoolElasticityProfile(property.Value, options);
                    continue;
                }
                if (property.NameEquals("containerGroupProperties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    containerGroupProperties = StandbyContainerGroupProperties.DeserializeStandbyContainerGroupProperties(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new StandbyContainerGroupPoolUpdateProperties(elasticityProfile, containerGroupProperties, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<StandbyContainerGroupPoolUpdateProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StandbyContainerGroupPoolUpdateProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(StandbyContainerGroupPoolUpdateProperties)} does not support writing '{options.Format}' format.");
            }
        }

        StandbyContainerGroupPoolUpdateProperties IPersistableModel<StandbyContainerGroupPoolUpdateProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StandbyContainerGroupPoolUpdateProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeStandbyContainerGroupPoolUpdateProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(StandbyContainerGroupPoolUpdateProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<StandbyContainerGroupPoolUpdateProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
