// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.SqlVirtualMachine.Models;

namespace Azure.ResourceManager.SqlVirtualMachine
{
    public partial class SqlVmGroupData : IUtf8JsonSerializable, IJsonModel<SqlVmGroupData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SqlVmGroupData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SqlVmGroupData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlVmGroupData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SqlVmGroupData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState);
            }
            if (Optional.IsDefined(SqlImageOffer))
            {
                writer.WritePropertyName("sqlImageOffer"u8);
                writer.WriteStringValue(SqlImageOffer);
            }
            if (Optional.IsDefined(SqlImageSku))
            {
                writer.WritePropertyName("sqlImageSku"u8);
                writer.WriteStringValue(SqlImageSku.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ScaleType))
            {
                writer.WritePropertyName("scaleType"u8);
                writer.WriteStringValue(ScaleType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ClusterManagerType))
            {
                writer.WritePropertyName("clusterManagerType"u8);
                writer.WriteStringValue(ClusterManagerType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(ClusterConfiguration))
            {
                writer.WritePropertyName("clusterConfiguration"u8);
                writer.WriteStringValue(ClusterConfiguration.Value.ToString());
            }
            if (Optional.IsDefined(WindowsServerFailoverClusterDomainProfile))
            {
                writer.WritePropertyName("wsfcDomainProfile"u8);
                writer.WriteObjectValue(WindowsServerFailoverClusterDomainProfile, options);
            }
            writer.WriteEndObject();
        }

        SqlVmGroupData IJsonModel<SqlVmGroupData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlVmGroupData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SqlVmGroupData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSqlVmGroupData(document.RootElement, options);
        }

        internal static SqlVmGroupData DeserializeSqlVmGroupData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IDictionary<string, string> tags = default;
            AzureLocation location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string provisioningState = default;
            string sqlImageOffer = default;
            SqlVmGroupImageSku? sqlImageSku = default;
            SqlVmGroupScaleType? scaleType = default;
            SqlVmClusterManagerType? clusterManagerType = default;
            SqlVmClusterConfiguration? clusterConfiguration = default;
            WindowsServerFailoverClusterDomainProfile windowsServerFailoverClusterDomainProfile = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            provisioningState = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("sqlImageOffer"u8))
                        {
                            sqlImageOffer = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("sqlImageSku"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sqlImageSku = new SqlVmGroupImageSku(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("scaleType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            scaleType = new SqlVmGroupScaleType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("clusterManagerType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            clusterManagerType = new SqlVmClusterManagerType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("clusterConfiguration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            clusterConfiguration = new SqlVmClusterConfiguration(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("wsfcDomainProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            windowsServerFailoverClusterDomainProfile = WindowsServerFailoverClusterDomainProfile.DeserializeWindowsServerFailoverClusterDomainProfile(property0.Value, options);
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SqlVmGroupData(
                id,
                name,
                type,
                systemData,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                location,
                provisioningState,
                sqlImageOffer,
                sqlImageSku,
                scaleType,
                clusterManagerType,
                clusterConfiguration,
                windowsServerFailoverClusterDomainProfile,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SqlVmGroupData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlVmGroupData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SqlVmGroupData)} does not support writing '{options.Format}' format.");
            }
        }

        SqlVmGroupData IPersistableModel<SqlVmGroupData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlVmGroupData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSqlVmGroupData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SqlVmGroupData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SqlVmGroupData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
