// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Net;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.SqlVirtualMachine.Models;

namespace Azure.ResourceManager.SqlVirtualMachine
{
    /// <summary>
    /// A class representing the SqlVm data model.
    /// A SQL virtual machine.
    /// </summary>
    public partial class SqlVmData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlVmData"/>. </summary>
        /// <param name="location"> The location. </param>
        public SqlVmData(AzureLocation location) : base(location)
        {
        }

        /// <summary> Initializes a new instance of <see cref="SqlVmData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> Azure Active Directory identity of the server. Current supported identity types: None, SystemAssigned. </param>
        /// <param name="virtualMachineResourceId"> ARM Resource id of underlying virtual machine created from SQL marketplace image. </param>
        /// <param name="provisioningState"> Provisioning state to track the async operation status. </param>
        /// <param name="sqlImageOffer"> SQL image offer. Examples include SQL2016-WS2016, SQL2017-WS2016. </param>
        /// <param name="sqlServerLicenseType"> SQL Server license type. </param>
        /// <param name="sqlManagement"> SQL Server Management type. </param>
        /// <param name="sqlImageSku"> SQL Server edition type. </param>
        /// <param name="sqlVmGroupResourceId"> ARM resource id of the SQL virtual machine group this SQL virtual machine is or will be part of. </param>
        /// <param name="windowsServerFailoverClusterDomainCredentials"> Domain credentials for setting up Windows Server Failover Cluster for SQL availability group. </param>
        /// <param name="windowsServerFailoverClusterStaticIP"> Domain credentials for setting up Windows Server Failover Cluster for SQL availability group. </param>
        /// <param name="autoPatchingSettings"> Auto patching settings for applying critical security updates to SQL virtual machine. </param>
        /// <param name="autoBackupSettings"> Auto backup settings for SQL Server. </param>
        /// <param name="keyVaultCredentialSettings"> Key vault credential settings. </param>
        /// <param name="serverConfigurationsManagementSettings"> SQL Server configuration management settings. </param>
        /// <param name="storageConfigurationSettings"> Storage Configuration Settings. </param>
        /// <param name="assessmentSettings"> Assessment Settings. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlVmData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ManagedServiceIdentity identity, ResourceIdentifier virtualMachineResourceId, string provisioningState, string sqlImageOffer, SqlServerLicenseType? sqlServerLicenseType, SqlManagementMode? sqlManagement, SqlImageSku? sqlImageSku, ResourceIdentifier sqlVmGroupResourceId, WindowsServerFailoverClusterDomainCredentials windowsServerFailoverClusterDomainCredentials, IPAddress windowsServerFailoverClusterStaticIP, SqlVmAutoPatchingSettings autoPatchingSettings, SqlVmAutoBackupSettings autoBackupSettings, SqlVmKeyVaultCredentialSettings keyVaultCredentialSettings, SqlServerConfigurationsManagementSettings serverConfigurationsManagementSettings, SqlVmStorageConfigurationSettings storageConfigurationSettings, SqlVmAssessmentSettings assessmentSettings, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Identity = identity;
            VirtualMachineResourceId = virtualMachineResourceId;
            ProvisioningState = provisioningState;
            SqlImageOffer = sqlImageOffer;
            SqlServerLicenseType = sqlServerLicenseType;
            SqlManagement = sqlManagement;
            SqlImageSku = sqlImageSku;
            SqlVmGroupResourceId = sqlVmGroupResourceId;
            WindowsServerFailoverClusterDomainCredentials = windowsServerFailoverClusterDomainCredentials;
            WindowsServerFailoverClusterStaticIP = windowsServerFailoverClusterStaticIP;
            AutoPatchingSettings = autoPatchingSettings;
            AutoBackupSettings = autoBackupSettings;
            KeyVaultCredentialSettings = keyVaultCredentialSettings;
            ServerConfigurationsManagementSettings = serverConfigurationsManagementSettings;
            StorageConfigurationSettings = storageConfigurationSettings;
            AssessmentSettings = assessmentSettings;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="SqlVmData"/> for deserialization. </summary>
        internal SqlVmData()
        {
        }

        /// <summary> Azure Active Directory identity of the server. Current supported identity types: None, SystemAssigned. </summary>
        public ManagedServiceIdentity Identity { get; set; }
        /// <summary> ARM Resource id of underlying virtual machine created from SQL marketplace image. </summary>
        public ResourceIdentifier VirtualMachineResourceId { get; set; }
        /// <summary> Provisioning state to track the async operation status. </summary>
        public string ProvisioningState { get; }
        /// <summary> SQL image offer. Examples include SQL2016-WS2016, SQL2017-WS2016. </summary>
        public string SqlImageOffer { get; set; }
        /// <summary> SQL Server license type. </summary>
        public SqlServerLicenseType? SqlServerLicenseType { get; set; }
        /// <summary> SQL Server Management type. </summary>
        public SqlManagementMode? SqlManagement { get; set; }
        /// <summary> SQL Server edition type. </summary>
        public SqlImageSku? SqlImageSku { get; set; }
        /// <summary> ARM resource id of the SQL virtual machine group this SQL virtual machine is or will be part of. </summary>
        public ResourceIdentifier SqlVmGroupResourceId { get; set; }
        /// <summary> Domain credentials for setting up Windows Server Failover Cluster for SQL availability group. </summary>
        public WindowsServerFailoverClusterDomainCredentials WindowsServerFailoverClusterDomainCredentials { get; set; }
        /// <summary> Domain credentials for setting up Windows Server Failover Cluster for SQL availability group. </summary>
        public IPAddress WindowsServerFailoverClusterStaticIP { get; set; }
        /// <summary> Auto patching settings for applying critical security updates to SQL virtual machine. </summary>
        public SqlVmAutoPatchingSettings AutoPatchingSettings { get; set; }
        /// <summary> Auto backup settings for SQL Server. </summary>
        public SqlVmAutoBackupSettings AutoBackupSettings { get; set; }
        /// <summary> Key vault credential settings. </summary>
        public SqlVmKeyVaultCredentialSettings KeyVaultCredentialSettings { get; set; }
        /// <summary> SQL Server configuration management settings. </summary>
        public SqlServerConfigurationsManagementSettings ServerConfigurationsManagementSettings { get; set; }
        /// <summary> Storage Configuration Settings. </summary>
        public SqlVmStorageConfigurationSettings StorageConfigurationSettings { get; set; }
        /// <summary> Assessment Settings. </summary>
        public SqlVmAssessmentSettings AssessmentSettings { get; set; }
    }
}
