// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Net;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.SqlVirtualMachine.Models;

namespace Azure.ResourceManager.SqlVirtualMachine
{
    public partial class SqlVmData : IUtf8JsonSerializable, IJsonModel<SqlVmData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SqlVmData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SqlVmData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlVmData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SqlVmData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(Identity))
            {
                writer.WritePropertyName("identity"u8);
                JsonSerializer.Serialize(writer, Identity);
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(VirtualMachineResourceId))
            {
                writer.WritePropertyName("virtualMachineResourceId"u8);
                writer.WriteStringValue(VirtualMachineResourceId);
            }
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState);
            }
            if (Optional.IsDefined(SqlImageOffer))
            {
                writer.WritePropertyName("sqlImageOffer"u8);
                writer.WriteStringValue(SqlImageOffer);
            }
            if (Optional.IsDefined(SqlServerLicenseType))
            {
                writer.WritePropertyName("sqlServerLicenseType"u8);
                writer.WriteStringValue(SqlServerLicenseType.Value.ToString());
            }
            if (Optional.IsDefined(SqlManagement))
            {
                writer.WritePropertyName("sqlManagement"u8);
                writer.WriteStringValue(SqlManagement.Value.ToString());
            }
            if (Optional.IsDefined(SqlImageSku))
            {
                writer.WritePropertyName("sqlImageSku"u8);
                writer.WriteStringValue(SqlImageSku.Value.ToString());
            }
            if (Optional.IsDefined(SqlVmGroupResourceId))
            {
                writer.WritePropertyName("sqlVirtualMachineGroupResourceId"u8);
                writer.WriteStringValue(SqlVmGroupResourceId);
            }
            if (Optional.IsDefined(WindowsServerFailoverClusterDomainCredentials))
            {
                writer.WritePropertyName("wsfcDomainCredentials"u8);
                writer.WriteObjectValue(WindowsServerFailoverClusterDomainCredentials, options);
            }
            if (Optional.IsDefined(WindowsServerFailoverClusterStaticIP))
            {
                writer.WritePropertyName("wsfcStaticIp"u8);
                writer.WriteStringValue(WindowsServerFailoverClusterStaticIP.ToString());
            }
            if (Optional.IsDefined(AutoPatchingSettings))
            {
                writer.WritePropertyName("autoPatchingSettings"u8);
                writer.WriteObjectValue(AutoPatchingSettings, options);
            }
            if (Optional.IsDefined(AutoBackupSettings))
            {
                writer.WritePropertyName("autoBackupSettings"u8);
                writer.WriteObjectValue(AutoBackupSettings, options);
            }
            if (Optional.IsDefined(KeyVaultCredentialSettings))
            {
                writer.WritePropertyName("keyVaultCredentialSettings"u8);
                writer.WriteObjectValue(KeyVaultCredentialSettings, options);
            }
            if (Optional.IsDefined(ServerConfigurationsManagementSettings))
            {
                writer.WritePropertyName("serverConfigurationsManagementSettings"u8);
                writer.WriteObjectValue(ServerConfigurationsManagementSettings, options);
            }
            if (Optional.IsDefined(StorageConfigurationSettings))
            {
                writer.WritePropertyName("storageConfigurationSettings"u8);
                writer.WriteObjectValue(StorageConfigurationSettings, options);
            }
            if (Optional.IsDefined(AssessmentSettings))
            {
                writer.WritePropertyName("assessmentSettings"u8);
                writer.WriteObjectValue(AssessmentSettings, options);
            }
            writer.WriteEndObject();
        }

        SqlVmData IJsonModel<SqlVmData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlVmData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SqlVmData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSqlVmData(document.RootElement, options);
        }

        internal static SqlVmData DeserializeSqlVmData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ManagedServiceIdentity identity = default;
            IDictionary<string, string> tags = default;
            AzureLocation location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            ResourceIdentifier virtualMachineResourceId = default;
            string provisioningState = default;
            string sqlImageOffer = default;
            SqlServerLicenseType? sqlServerLicenseType = default;
            SqlManagementMode? sqlManagement = default;
            SqlImageSku? sqlImageSku = default;
            ResourceIdentifier sqlVmGroupResourceId = default;
            WindowsServerFailoverClusterDomainCredentials windowsServerFailoverClusterDomainCredentials = default;
            IPAddress windowsServerFailoverClusterStaticIP = default;
            SqlVmAutoPatchingSettings autoPatchingSettings = default;
            SqlVmAutoBackupSettings autoBackupSettings = default;
            SqlVmKeyVaultCredentialSettings keyVaultCredentialSettings = default;
            SqlServerConfigurationsManagementSettings serverConfigurationsManagementSettings = default;
            SqlVmStorageConfigurationSettings storageConfigurationSettings = default;
            SqlVmAssessmentSettings assessmentSettings = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("identity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    identity = JsonSerializer.Deserialize<ManagedServiceIdentity>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("virtualMachineResourceId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            virtualMachineResourceId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            provisioningState = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("sqlImageOffer"u8))
                        {
                            sqlImageOffer = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("sqlServerLicenseType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sqlServerLicenseType = new SqlServerLicenseType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("sqlManagement"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sqlManagement = new SqlManagementMode(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("sqlImageSku"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sqlImageSku = new SqlImageSku(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("sqlVirtualMachineGroupResourceId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            sqlVmGroupResourceId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("wsfcDomainCredentials"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            windowsServerFailoverClusterDomainCredentials = WindowsServerFailoverClusterDomainCredentials.DeserializeWindowsServerFailoverClusterDomainCredentials(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("wsfcStaticIp"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            windowsServerFailoverClusterStaticIP = IPAddress.Parse(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("autoPatchingSettings"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            autoPatchingSettings = SqlVmAutoPatchingSettings.DeserializeSqlVmAutoPatchingSettings(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("autoBackupSettings"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            autoBackupSettings = SqlVmAutoBackupSettings.DeserializeSqlVmAutoBackupSettings(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("keyVaultCredentialSettings"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            keyVaultCredentialSettings = SqlVmKeyVaultCredentialSettings.DeserializeSqlVmKeyVaultCredentialSettings(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("serverConfigurationsManagementSettings"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            serverConfigurationsManagementSettings = SqlServerConfigurationsManagementSettings.DeserializeSqlServerConfigurationsManagementSettings(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("storageConfigurationSettings"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            storageConfigurationSettings = SqlVmStorageConfigurationSettings.DeserializeSqlVmStorageConfigurationSettings(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("assessmentSettings"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            assessmentSettings = SqlVmAssessmentSettings.DeserializeSqlVmAssessmentSettings(property0.Value, options);
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SqlVmData(
                id,
                name,
                type,
                systemData,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                location,
                identity,
                virtualMachineResourceId,
                provisioningState,
                sqlImageOffer,
                sqlServerLicenseType,
                sqlManagement,
                sqlImageSku,
                sqlVmGroupResourceId,
                windowsServerFailoverClusterDomainCredentials,
                windowsServerFailoverClusterStaticIP,
                autoPatchingSettings,
                autoBackupSettings,
                keyVaultCredentialSettings,
                serverConfigurationsManagementSettings,
                storageConfigurationSettings,
                assessmentSettings,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SqlVmData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlVmData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SqlVmData)} does not support writing '{options.Format}' format.");
            }
        }

        SqlVmData IPersistableModel<SqlVmData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlVmData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSqlVmData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SqlVmData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SqlVmData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
