// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SqlVirtualMachine.Models
{
    /// <summary> Domain credentials for setting up Windows Server Failover Cluster for SQL availability group. </summary>
    public partial class WindowsServerFailoverClusterDomainCredentials
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="WindowsServerFailoverClusterDomainCredentials"/>. </summary>
        public WindowsServerFailoverClusterDomainCredentials()
        {
        }

        /// <summary> Initializes a new instance of <see cref="WindowsServerFailoverClusterDomainCredentials"/>. </summary>
        /// <param name="clusterBootstrapAccountPassword"> Cluster bootstrap account password. </param>
        /// <param name="clusterOperatorAccountPassword"> Cluster operator account password. </param>
        /// <param name="sqlServiceAccountPassword"> SQL service account password. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal WindowsServerFailoverClusterDomainCredentials(string clusterBootstrapAccountPassword, string clusterOperatorAccountPassword, string sqlServiceAccountPassword, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ClusterBootstrapAccountPassword = clusterBootstrapAccountPassword;
            ClusterOperatorAccountPassword = clusterOperatorAccountPassword;
            SqlServiceAccountPassword = sqlServiceAccountPassword;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Cluster bootstrap account password. </summary>
        public string ClusterBootstrapAccountPassword { get; set; }
        /// <summary> Cluster operator account password. </summary>
        public string ClusterOperatorAccountPassword { get; set; }
        /// <summary> SQL service account password. </summary>
        public string SqlServiceAccountPassword { get; set; }
    }
}
